<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\BulkOperation;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class BulkOperationQL extends Common
{
	public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function createBulkOperation($params)
    {
        $this->init();

        if($this->_salesChannel) {
            if($params['type'] === 'product') {
                $params['type'] = 'saleschannelproduct';
            }
        }

        $bulk_query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\BulkOperationQuery')->getBulkOperationQuery($params);
        $this->di->getLog()->logContent('params : ' . json_encode($params),'info', __FUNCTION__ . '.log');
        $this->di->getLog()->logContent('bulk_query : ' . json_encode($bulk_query),'info', __FUNCTION__ . '.log');

        if($bulk_query['success']) {
            $bulkQuery = $bulk_query['query'];
            $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\QueryQL')->getBulkOperationCreateMutation($bulkQuery);
            $data = $this->graph($query);
            
            $response = $data['body'];

            $parsed_response = $this->parseResponse(current($response));
            // $parsed_response['sales_channel'] = $this->_salesChannel ? 1 : 0;
            if($parsed_response['success']) {
                $parsed_response['data'] = $parsed_response['data']['bulkOperation'];
                return $parsed_response;
            }
            else {
                return $parsed_response;
            }
        }
        else {
            return $bulk_query;
        }
    }

    public function getCurrentBulkOperation()
    {
        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\QueryQL')->getCurrentBulkOperationQuery();
        $data = $this->init()->graph($query);
        
        $response = $data['body'];
        
        $parsed_response = $this->parseResponse($response);
        if($parsed_response['success']) {
            $parsed_response['data'] = current($parsed_response['data']);
            return $parsed_response;
        }
        else {
            return $parsed_response;
        }
    }

    public function getBulkOperation($id)
    {
        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\QueryQL')->getBulkOperationQuery($id);
        $data = $this->init()->graph($query);

        $response = $data['body'];

        $parsed_response = $this->parseResponse($response);
        if($parsed_response['success']) {
            $response_data = current($parsed_response['data']);
            if($response_data) {
                return [
                    'success' => true,
                    'data'    => $response_data  
                ];
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'Not Found'
                ];
            }
        }
        else {
            return $parsed_response;
        }
    }

    public function cancelBulkOpearion($id)
    {
        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\QueryQL')->getBulkOperationCancelMutation($id);
        $data = $this->init()->graph($query);
        
        $response = $data['body'];

        $parsed_response = $this->parseResponse(current($response));
        if($parsed_response['success']) {
            $parsed_response['data'] = $parsed_response['data']['bulkOperation'];
            return $parsed_response;
        }
        else {
            return $parsed_response;
        }
    }

    public function parseResponse($response)
    {
        if(isset($response['userErrors']) && !empty($response['userErrors'])) {
            if(isset($response['userErrors'][0])) {
                $error = $response['userErrors'][0];
            } else {
                $error = $response['userErrors'];
            }

            if(isset($error['message']))
                $msg = $error['message'];
            else
                $msg = 'Something went wrong at shopify.';

            return [
                'success'   => false,
                'msg'       => $msg,
                'error'     => $error
            ];
        }
        elseif(isset($response['message']) && !empty($response['message'])) {
            return [
                'success'   => false,
                'msg'       => 'query is not valid',
                'error'     => $response['message']
            ];
        }
        else {
            return [
                'success'   => true,
                'data'      => $response,
                'sales_channel' => $this->_salesChannel ? 1 : 0
            ];
        }
    }
}