<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Billing;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class UsageCharge extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }


    public function createUsageApplicationCharge($data)
    {
        if(isset($data['description'], $data['price'], $data['charge_id'])) {
            $this->init(false);
            $chargeId = (string)$data['charge_id'];
            $recurringUsageChargeData['usage_charge'] = [
                'description' => $data['description'],
                'price' => $data['price']
            ];
            $response = $this->rest('POST', 'recurring_application_charges/'.$chargeId.'/usage_charges.json', $recurringUsageChargeData);
            return $this->formatRestResponse($response);

        }else
        {
            return [
                'status'    => false,
                'error'     => '"description", "price" and "charge_id" are required.'
            ];
        }
    }
}
