<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Billing;

use Exception;
use App\Shopifywebapi\Components\Core\Common;
use App\Shopifywebapi\Components\Core\GraphQLInputTypes\Money;
use rdx\graphqlquery\Query as phpGraphQueryBuilder;

class RecurringQL extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getRecurringApplicationCharges($filter = [])
    {
        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\QueryQL')->getAppSubscriptionsQuery($filter);

        $data = $this->init()->graph($query);
        return $data['body'];
    }

    public function createRecurringApplicationCharge($post_data)
    {
        /* data[name]=First Recurring Payment&data[return_url]=https://satya-ka-store.myshopify.com/payment&data[currency_code]=USD&data[test]=1&data[trial_days]=7&data[price]=39&data[capped_amount]=39 */
        $data = $post_data['data']??[];

        $data['currency_code'] = $data['currency_code']??'USD';

        //if(isset($data['name'], $data['return_url'], $data['currency_code'])) {
        if(isset($data['name'], $data['return_url'])) {
            if(isset($data['price']) || isset($data['capped_amount'])) {
                $mutationData = [
                    'name'      => $data['name'],
                    'returnUrl' => $data['return_url']
                ];

                if(isset($data['test']) && $data['test']) {
                    $mutationData['test'] = true;
                }

                if(isset($data['trial_days'])) {
                    if(is_numeric($data['trial_days']))
                        $mutationData['trialDays'] = $data['trial_days'];
                    else {
                        return [
                            'success'   => false,
                            'msg'       => 'trial_days must be integer'
                        ];
                    }
                }

                $line_items = $this->prepareLineItems($data, $mutationData);
                if($line_items['status'] === true) {
                    $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\QueryQL')->getAppSubscriptionCreateMutation($mutationData);

                    $data = $this->init()->graph($query);
                    // print_r($data['body']);die;

                    if(isset($data['body']['appSubscriptionCreate'])) {
                        $response = $data['body']['appSubscriptionCreate'];

                        if(isset($response['userErrors']) && !empty($response['userErrors'])) {
                            if(isset($response['userErrors'][0])) {
                                $error = $response['userErrors'][0];
                            } else {
                                $error = $response['userErrors'];
                            }

                            if(isset($error['message']))
                                $msg = $error['message'];
                            else
                                $msg = 'Something went wrong at shopify.';

                            return [
                                'success'   => false,
                                'msg'       => $msg,
                                'error'     => $error
                            ];
                        }
                        else {
                            $methods = [
                                'createdAt' => function($value, &$formattedData) {
                                    $formattedData['created_at'] = $value;
                                },
                                'currentPeriodEnd' => function($value, &$formattedData) {
                                    $formattedData['current_period_end'] = $value;
                                },
                                'lineItems' => function($value, &$formattedData) {
                                    $formattedData['line_items'] = $value;
                                },
                                'trialDays' => function($value, &$formattedData) {
                                    $formattedData['trial_days'] = $value;
                                },
                            ];

                            $formattedData['confirmation_url'] = $response['confirmationUrl'];

                            foreach ($response['appSubscription'] as $key => $value) {
                                if(isset($methods[$key])) {
                                    $methods[$key]($value, $formattedData);
                                } else {
                                    $formattedData[$key] = $value;
                                }
                            }

                            return [
                                'success'   => true,
                                'data'      => $formattedData
                            ];
                        }
                    }
                    else {
                        if(isset($data['body']['message'])) {
                            $error = $data['body'];
                        }
                        elseif(isset($data['body'][0]['message'])) {
                            $error = $data['body'][0];
                        }
                        
                        $return = [
                            'success'   => false,
                            'msg'       => 'Something went wrong.',
                        ];

                        if(isset($error)) {
                            $return['error'] = $error;
                        }

                        return $return;
                    }
                }
                else {
                    return [
                        'success'   => false,
                        'msg'       => $line_items['error']
                    ];
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'price OR capped_amount is missing.'
                ];
            }
        }
        else {
            return [
                'success'   => false,
                'msg'       => 'name OR return_url OR currency_code is missing.'
            ];
        }
    }

    private function prepareLineItems($data, &$mutationData)
    {
        $appSubscriptionData = $appRecurringPricingDetails = [];

        $moneyFormatter = new Money();

        if(isset($data['price'])) {
            $recurringAmount = $moneyFormatter->format($data['price'], $data['currency_code']);
            if($recurringAmount === false) {
                return ['status' => false, 'error' => $moneyFormatter->getError()];
            }
            else {
                $appRecurringPricingDetails['price'] = $recurringAmount;
                if (isset($data['interval']) && $data['interval']) {                    
                    $appRecurringPricingDetails['interval'] = phpGraphQueryBuilder::enum('ANNUAL');
                }
                $appSubscriptionData[]['plan']['appRecurringPricingDetails'] = $appRecurringPricingDetails;
            }
        }

        if(isset($data['capped_amount'])) {
            if(isset($data['terms'])) {
                $cappedAmount = $moneyFormatter->format($data['capped_amount'], $data['currency_code']);
                if($cappedAmount === false) {
                    return ['status' => false, 'error' => $moneyFormatter->getError()];
                }
                else {
                    $capped_amount_data = ['cappedAmount' => $cappedAmount, 'terms' => $data['terms']];
                    $appSubscriptionData[]['plan']['appUsagePricingDetails'] = $capped_amount_data;
                }
            }
            else {
                return [
                    'status'    => false,
                    'error'     => '"terms" are required if "capped_amount" is provided.'
                ];
            }
        }

        $mutationData['lineItems'] = $appSubscriptionData;

        return ['status' => true];
    }

    public function cancelRecurringApplicationCharge($data)
    {
        $this->init(false);

        $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\QueryQL')->getAppSubscriptionCancelMutation($data);

        $data = $this->init()->graph($query);

        if(isset($data['body']['appSubscriptionCancel'])) {
            $response = $data['body']['appSubscriptionCancel'];

            if(isset($response['userErrors']) && !empty($response['userErrors'])) {
                if(isset($response['userErrors'][0])) {
                    $error = $response['userErrors'][0];
                } else {
                    $error = $response['userErrors'];
                }

                if(isset($error['message']))
                    $msg = $error['message'];
                else
                    $msg = 'Something went wrong at shopify.';

                return [
                    'success'   => false,
                    'msg'       => $msg,
                    'error'     => $error
                ];
            }
            else {
                $methods = [
                    'createdAt' => function($value, &$formattedData) {
                        $formattedData['created_at'] = $value;
                    },
                    'currentPeriodEnd' => function($value, &$formattedData) {
                        $formattedData['current_period_end'] = $value;
                    },
                    'lineItems' => function($value, &$formattedData) {
                        $formattedData['line_items'] = $value;
                    },
                    'trialDays' => function($value, &$formattedData) {
                        $formattedData['trial_days'] = $value;
                    },
                ];

                $formattedData = [];

                foreach ($response['appSubscription'] as $key => $value) {
                    if(isset($methods[$key])) {
                        $methods[$key]($value, $formattedData);
                    } else {
                        $formattedData[$key] = $value;
                    }
                }

                return [
                    'success'   => true,
                    'data'      => $formattedData
                ];
            }
        }
        else {
            if(isset($data['body']['message'])) {
                $error = $data['body'];
            }
            elseif(isset($data['body'][0]['message'])) {
                $error = $data['body'][0];
            }
            
            $return = [
                'success'   => false,
                'msg'       => 'Something went wrong.',
            ];

            if(isset($error)) {
                $return['error'] = $error;
            }

            return $return;
        }
    }
}