<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Billing;

use rdx\graphqlquery\Query as phpGraphQueryBuilder;

class QueryQL
{
    /*public function getAppSubscriptionsQuery($filter)
    {
        $query = phpGraphQueryBuilder::query('', []);
        $query->fields('appInstallations');
        $query->webhookSubscriptions->fields('edges', ['node' => ['allSubscriptions']]);
        $query->webhookSubscriptions->edges->fields('node');
        $query->webhookSubscriptions->edges->node->fields('id', 'topic', 'callbackUrl');
        return $query->build();
    }*/

    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getAppSubscriptionCreateMutation($data)
    {
        /*mutation appSubscriptionCreate($name: String!, $lineItems: [AppSubscriptionLineItemInput!]!, $returnUrl: URL!) {
          appSubscriptionCreate(name: $name, lineItems: $lineItems, returnUrl: $returnUrl) {
            appSubscription {
              id
            }
            confirmationUrl
            userErrors {
              field
              message
            }
          }
        }*/
        $appSubscriptionFields = ['id', 'createdAt', 'currentPeriodEnd', 'name', 'status', 'test', 'trialDays'];

        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('appSubscriptionCreate');
        $mutation->appSubscriptionCreate->attribute('name', $data['name']);
        $mutation->appSubscriptionCreate->attribute('lineItems', $data['lineItems']);
        $mutation->appSubscriptionCreate->attribute('returnUrl', $data['returnUrl']);
        $mutation->appSubscriptionCreate->field('confirmationUrl');
        $mutation->appSubscriptionCreate->field('userErrors');
        $mutation->appSubscriptionCreate->userErrors->field('field');
        $mutation->appSubscriptionCreate->userErrors->field('message');

        if(isset($data['test'])) {
            $mutation->appSubscriptionCreate->attribute('test', $data['test']);
        }

        if(isset($data['trialDays'])) {
            $mutation->appSubscriptionCreate->attribute('trialDays', intval($data['trialDays']));
        }

        $mutation->appSubscriptionCreate->field('appSubscription');
        foreach ($appSubscriptionFields as $field) {
            $mutation->appSubscriptionCreate->appSubscription->field($field);
        }

        return $mutation->build();
    }

    /**
     * Modifying query here doesn't reflect on live, kindly note this query output is being cached
     * So plz fluch cache once made changes here
     * @return string
     */
    public function getAppSubscriptionCancelMutation($data)
    {
        /*mutation appSubscriptionCancel($id: ID!) {
          appSubscriptionCancel(id: $id) {
            appSubscription {
              id
            }
            userErrors {
              field
              message
            }
          }
        }*/
        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('appSubscriptionCancel');
        $mutation->appSubscriptionCancel->attribute('id', 'gid://shopify/AppSubscription/'.$data['id']);
        $mutation->appSubscriptionCancel->field('appSubscription');
        $mutation->appSubscriptionCancel->appSubscription->field('id');
        $mutation->appSubscriptionCancel->appSubscription->field('name');
        $mutation->appSubscriptionCancel->appSubscription->field('createdAt');
        $mutation->appSubscriptionCancel->appSubscription->field('status');
        $mutation->appSubscriptionCancel->field('userErrors');
        $mutation->appSubscriptionCancel->userErrors->field('field');
        $mutation->appSubscriptionCancel->userErrors->field('message');
        return $mutation->build();
    }

    public function getAppPurchaseOneTimeCreateMutation($data)
    {
        /*mutation appPurchaseOneTimeCreate($name: String!, $price: MoneyInput!, $returnUrl: URL!) {
          appPurchaseOneTimeCreate(name: $name, price: $price, returnUrl: $returnUrl) {
            appPurchaseOneTime {
              id
            }
            confirmationUrl
            userErrors {
              field
              message
            }
          }
        }*/
        $appSubscriptionFields = ['id', 'createdAt', 'name', 'status', 'test'];

        $mutation = phpGraphQueryBuilder::mutation('', []);
        $mutation->field('appPurchaseOneTimeCreate');
        $mutation->appPurchaseOneTimeCreate->attribute('name', $data['name']);
        $mutation->appPurchaseOneTimeCreate->attribute('price', $data['price']);
        $mutation->appPurchaseOneTimeCreate->attribute('returnUrl', $data['returnUrl']);
        $mutation->appPurchaseOneTimeCreate->field('confirmationUrl');
        $mutation->appPurchaseOneTimeCreate->field('userErrors');
        $mutation->appPurchaseOneTimeCreate->userErrors->field('field');
        $mutation->appPurchaseOneTimeCreate->userErrors->field('message');
        $mutation->appPurchaseOneTimeCreate->attribute('test', $data['test']);
        $mutation->appPurchaseOneTimeCreate->field('appPurchaseOneTime');
        foreach ($appSubscriptionFields as $field) {
            $mutation->appPurchaseOneTimeCreate->appPurchaseOneTime->field($field);
        }
        $mutation->appPurchaseOneTimeCreate->appPurchaseOneTime->field('price');
        $mutation->appPurchaseOneTimeCreate->appPurchaseOneTime->price->field('amount');
        $mutation->appPurchaseOneTimeCreate->appPurchaseOneTime->price->field('currencyCode');

        return $mutation->build();
    }
}