<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Billing;

use Exception;
use App\Shopifywebapi\Components\Core\Common;
use App\Shopifywebapi\Components\Core\GraphQLInputTypes\Money;

class OneTimeQL extends Common
{
	public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function createApplicationCharge($post_data)
    {
        /* data%5Bname%5D=First%20OneTime%20Payment%20Via%20Rest&data%5Breturn_url%5D=https%3A%2F%2Fsatya-ka-store.myshopify.com%2Fpayment&data%5Btest%5D=1&data%5Bprice%5D=39 */
        $data = $post_data['data']??[];

        $data['currency_code'] = $data['currency_code']??'USD';

        if(isset($data['name'], $data['return_url'], $data['price'])) {
            $mutationData = [
                'name'      => $data['name'],
                'returnUrl' => $data['return_url']
            ];

            if(isset($data['test']) && $data['test']) {
                $mutationData['test'] = true;
            }
            else {
                $mutationData['test'] = false;
            }

            $moneyFormatter = new Money();
            $price = $moneyFormatter->format($data['price'], $data['currency_code']);
            if($price === false) {
                return ['status' => false, 'error' => $moneyFormatter->getError()];
            }
            else {
                $mutationData['price'] = $price;

                $query = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\QueryQL')->getAppPurchaseOneTimeCreateMutation($mutationData);

                $data = $this->init()->graph($query);

                if(isset($data['body']['appPurchaseOneTimeCreate'])) {
                    $response = $data['body']['appPurchaseOneTimeCreate'];

                    if(isset($response['userErrors']) && !empty($response['userErrors'])) {
                        if(isset($response['userErrors'][0])) {
                            $error = $response['userErrors'][0];
                        } else {
                            $error = $response['userErrors'];
                        }

                        if(isset($error['message']))
                            $msg = $error['message'];
                        else
                            $msg = 'Something went wrong at shopify.';

                        return [
                            'success'   => false,
                            'msg'       => $msg,
                            'error'     => $error
                        ];
                    }
                    else {
                        $methods = [
                            'id' => function($value, &$formattedData) {
                                $formattedData['id'] = $this->getIdFromGraphqlId($value);
                            },
                            'createdAt' => function($value, &$formattedData) {
                                $formattedData['created_at'] = $value;
                            },
                            'currentPeriodEnd' => function($value, &$formattedData) {
                                $formattedData['current_period_end'] = $value;
                            },
                            'lineItems' => function($value, &$formattedData) {
                                $formattedData['line_items'] = $value;
                            },
                            'trialDays' => function($value, &$formattedData) {
                                $formattedData['trial_days'] = $value;
                            },
                            'price' => function($value, &$formattedData) {
                                $formattedData['price'] = $value['amount'];
                                $formattedData['currency_code'] = $value['currencyCode'];
                            }
                        ];

                        $formattedData['confirmation_url'] = $response['confirmationUrl'];

                        foreach ($response['appPurchaseOneTime'] as $key => $value) {
                            if(isset($methods[$key])) {
                                $methods[$key]($value, $formattedData);
                            } else {
                                $formattedData[$key] = $value;
                            }
                        }

                        return [
                            'success'   => true,
                            'data'      => $formattedData
                        ];
                    }
                }
                else {
                    if(isset($data['body']['message'])) {
                        $error = $data['body'];
                    }
                    elseif(isset($data['body'][0]['message'])) {
                        $error = $data['body'][0];
                    }
                    
                    $return = [
                        'success'   => false,
                        'msg'       => 'Something went wrong.',
                    ];

                    if(isset($error)) {
                        $return['error'] = $error;
                    }

                    return $return;
                }
            }
        }
        else {
            return [
                'success'   => false,
                'msg'       => 'name OR return_url OR price is missing.'
            ];
        }
    }
}