<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Shopifynxtgen
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Shopifywebapi\Components\Billing;

use App\Shopifywebapi\Components\Core\Common;
use Exception;

class OneTime extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function getApplicationCharges($filter = [])
    {
        $this->init(false);

        if(isset($filter['id'])) {
            $response = $this->rest('GET', 'application_charges/'.$filter['id'].'.json');
        }
        else {
            if(isset($filter['prev']) || isset($filter['next'])) {
                $cursor = base64_decode($filter['prev']??$filter['next']);
                parse_str($cursor, $params);
            }
            else {
                $default_params = [
                    'limit'     => 250
                ];

                $params = array_merge($default_params, $filter);
            }
            
            $response = $this->rest('GET', 'application_charges.json', $params);   
        }

        return $this->formatRestResponse($response);
    }

    public function createApplicationCharge($data)
    {
        /* data%5Bname%5D=First%20OneTime%20Payment%20Via%20Rest&data%5Breturn_url%5D=https%3A%2F%2Fsatya-ka-store.myshopify.com%2Fpayment&data%5Btest%5D=1&data%5Bprice%5D=39 */
        $this->init(false);

        $onetimeChargeData = $this->preparePostData($data['data']);
        if($onetimeChargeData['status']) {
            $response = $this->rest('POST', 'application_charges.json', $onetimeChargeData['data']);
            return $this->formatRestResponse($response);
        }
        else {
            return [
                'success' => false,
                'msg'     => $onetimeChargeData['error']
            ];
        }
    }

    public function preparePostData($data)
    {
        if(isset($data['name'], $data['price'], $data['return_url']))
        {
            $postData = [
                'name'      => $data['name'],
                'price'     => $data['price'],
                'return_url'=> $data['return_url']
            ];

            if($data['test']) {
                $postData['test'] = true;
            }

            return [
                'status'=> true,
                'data'  => ['application_charge' => $postData]
            ];
        }
        else
        {
            return [
                'status'    => false,
                'error'     => '"name", "price" and "return_url" are required.'
            ];
        }
    }

    public function activateApplicationCharge($data)
    {
        $this->init(false);

        $response = $this->rest('POST', 'application_charges/'.$data['id'].'/activate.json');

        return $this->formatRestResponse($response);
    }
}
