<?php

namespace App\Shopifywebapi\Components\Billing;

use App\Shopifywebapi\Components\Core\Common;

class Credit extends Common
{
    public function _construct()
    {
        $this->_callName = 'shopify_core';
        parent::_construct();
    }

    public function createApplicationCredits($data)
    {
        $this->init(false);

        $prepareDataResponse = $this->preparePostData($data['data']);
        if (!$prepareDataResponse['success']) {
            return $prepareDataResponse;
        }
        $response = $this->rest('POST', 'application_credits.json', $prepareDataResponse['data']);
        return $this->formatRestResponse($response);
    }

    public function preparePostData($data)
    {
        if (!isset($data['description'], $data['amount'])) {
            return [
                'success' => false,
                'message' => 'description and amount are required.'
            ];
        }
        $postData = [
            'description' => $data['description'],
            'amount' => $data['amount']
        ];
        if (isset($data['currency'])) {
            $postData['currency'] = $data['currency'];
        }

        if (isset($data['test']) && $data['test']) {
            $postData['test'] = true;
        }

        return [
            'success' => true,
            'data'  => ['application_credit' => $postData]
        ];
    }
}
