<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;
use Aws\DynamoDb\DynamoDbClient;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Webhook extends Base
{
    protected $_component = 'Webhook';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                // $default_params = ['_url', 'appId', 'shop_id', 'sAppId'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\Webhook'.$callType)->getWebhook($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function create($data)
    {
        /* data[0][topic]=products/create&data[0][address]=https://whatever.hostname.com/product/create&data[0][format]=json&data[0][key]=identity_key_1&data[1][topic]=products/update&data[1][address]=https://whatever.hostname.com/product/update&data[1][format]=json&data[1][key]=identity_key_2&data[2][topic]=products/delete&data[2][address]=https://whatever.hostname.com/product/delete&data[2][format]=json&data[2][key]=identity_key_3 */
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\Webhook'.$callType);

                $webhook = $data['data'];
                if(is_numeric(key($webhook))) {
                    $response = [];
                    foreach ($webhook as $_key => $_webhook) {
                        $webhookKey = $_webhook['key']??$_key;

                        $webhookData = $this->prepareCreateWebhookData($_webhook);
                        if($webhookData['status']) {
                            $resp = $object->createWebhook($webhookData['data']);
                            if($resp['success']) {
                                $response['success'][$webhookKey] = $resp['data']['webhook'];
                            }
                            else {
                                $response['error'][$webhookKey] = $resp['msg'];
                            }
                        }
                        else {
                            $response['error'][$webhookKey] = $webhookData['error'];
                        }
                    }

                    if(isset($response['success'])) {
                        return [
                            'success'   => true,
                            'data'      => $response
                        ];
                    }
                    else {
                        return [
                            'success'   => false,
                            'msg'       => $response['error']
                        ];
                    }
                }
                else {
                    $webhookData = $this->prepareCreateWebhookData($webhook);
                    if($webhookData['status']) {
                        $resp = $object->createWebhook($webhookData['data']);
                        if($resp['success']) {
                            $resp['data'] = $resp['data']['webhook'];
                        }

                        return $resp;
                    }
                    else {
                        return [
                            'success'   => false,
                            'msg'       => $webhookData['error']
                        ]; 
                    }
                }
            }
            else
            {
            	return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function prepareCreateWebhookData($data)
    {
        if(isset($data['topic'], $data['address'], $data['format'])) {
            return [
                'status'    => true,
                'data'      => [
                    'webhook'   => [
                        'topic'     => $data['topic'],
                        'address'   => $data['address'],
                        'format'      => $data['format']
                    ]
                ]
            ];
        }
        else {
            return [
                'status'    => false,
                'error'     => 'topic, address & format is required.'
            ];
        }
    }

    public function update($data)
    {
        //data[0][id]=765863657608&data[0][address]=https://update-whatever.hostname.com/product/create&data[1][id]=765863723144&data[1][address]=https://update-whatever.hostname.com/product/update
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\Webhook'.$callType);

                $webhook = $data['data'];
                if(is_numeric(key($webhook))) {
                    $response = [];
                    foreach ($webhook as $_key => $_webhook) {
                        $webhookData = $this->prepareUpdateWebhookData($_webhook);
                        if($webhookData['status']) {
                            $webhookKey = $_webhook['id'];
                            $resp = $object->updateWebhook($webhookData['data']);
                            if($resp['success']) {
                                $response['success'][$webhookKey] = $resp['data']['webhook'];
                            }
                            else {
                                $response['error'][$webhookKey] = $resp['msg'];
                            }
                        }
                        else {
                            $webhookKey = $_webhook['id']??$_key;
                            $response['error'][$webhookKey] = $webhookData['error'];
                        }
                    }

                    if(isset($response['success'])) {
                        return [
                            'success'   => true,
                            'data'      => $response
                        ];
                    }
                    else {
                        return [
                            'success'   => false,
                            'msg'       => $response['error']
                        ];
                    }
                }
                else {
                    $webhookData = $this->prepareUpdateWebhookData($webhook);
                    if($webhookData['status']) {
                        $resp = $object->updateWebhook($webhookData['data']);
                        
                        if($resp['success']) {
                            $resp['data'] = $resp['data']['webhook'];
                        }

                        return $resp;
                    }
                    else {
                        return [
                            'success'   => false,
                            'msg'       => $webhookData['error']
                        ]; 
                    }
                }
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function prepareUpdateWebhookData($data)
    {
        if(isset($data['id']) && (isset($data['address']) || isset($data['format']))) {
            $update_data = ['id' => $data['id']];
            if(isset($data['address'])) {
                $update_data['address'] = $data['address'];
            }

            if(isset($data['format'])) {
                $update_data['format'] = $data['format'];
            }
            return [
                'status'    => true,
                'data'      => [
                    'webhook'   => $update_data
                ]
            ];
        }
        else {
            return [
                'status'    => false,
                'error'     => 'id, (address | format) is required.'
            ];
        }
    }

    public function delete($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\Webhook'.$callType);

                if(isset($data['id'])) {
                    return $object->deleteWebhook(['id'=>$data['id']]);
                }
                elseif(isset($data['ids'])) {
                    $response = [];
                    $ids = explode(',', $data['ids']);
                    foreach ($ids as $id) {
                        $resp = $object->deleteWebhook(['id'=>$id]);
                        if($resp['success']) {
                            $response['success'][$id] = $id;
                        }
                        else {
                            $response['error'][$id] = $resp['msg'];
                        }
                    }

                    if(isset($response['success'])) {
                        return [
                            'success'   => true,
                            'data'      => $response
                        ];
                    }
                    else {
                        return [
                            'success'   => false,
                            'msg'       => $response['error']
                        ];
                    }
                }
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function register($request_data)
    {
        /* data%5Bqueue_config%5D%5Bregion%5D=us-east-2&data%5Bqueue_config%5D%5Bkey%5D=AKIAU3EY6KRDQFDRONHT&data%5Bqueue_config%5D%5Bsecret%5D=OYob0fVkrzYCSkIZ0bV%2BfWQWhzo4TmNlNPKOaysZ&data%5Bqueue_name%5D=product_create&data%5Btype%5D=sqs&data%5Btopic%5D=products%2Fcreate&data%5Bqueue_unique_id%5D=sqs-id-1&data%5Bformat%5D=json&data%5Bqueue_data%5D%5Bclass_name%5D=class&data%5Bqueue_data%5D%5Bmethod%5D=method */
        $data = $request_data['data'];
        $webhook_data = $request_data['webhook'];

        $data = array_merge($data, $webhook_data);

        $skip_register_on_shopify = false;
        try {
            if(/*isset($request_data['skip_register_on_shopify']) || */$shop = $this->di->getRegistry()->getCurrentShop())
            {
                $baseWebhookUrl = $this->di->getConfig()->get('base_webhook_url');
                if(is_null($baseWebhookUrl))
                {
                    return ['success' => false, 'msg' => 'base_webhook_url is not configured.'];
                }
                else
                {
                    if(isset($request_data['skip_register_on_shopify'])) {
                        $skip_register_on_shopify = true;
                    }
                    $validate = $this->validatePostData($data);
                    if($validate['status'])
                    {
                        $type = $data['type']??'sqs';

                        switch ($type) {
                            case 'sqs':
                                $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\Sqs');
                                break;
                        }

                        if(isset($object))
                        {
                            $queue = $object->createQueue($data);
                            if($queue['success'])
                            {
                                $data['queue_url'] = $queue['queue_url'];

                                $configSave = $this->saveConfig($data);
                                if($configSave['success']) {
                                    $webhookData = [
                                        'data'      => [
                                            'topic'     => $data['topic'],
                                            'address'   => $this->getWebhookAddress($configSave['id'], $data, $baseWebhookUrl),
                                            'format'    => $data['format']??'json'
                                        ],
                                        'call_type' => ''
                                    ];
                                    if(!$skip_register_on_shopify) {
                                        $result = $this->create($webhookData);
                                        $result['config_save_result'] = $configSave;
                                        return $result;
                                    }
                                    else {
                                        return [
                                            'success' => true,
                                            'message' => 'Registered Successfully',
                                            'address' => $this->getWebhookAddress($configSave['id'], $data, $baseWebhookUrl)
                                        ];
                                    }

                                }
                                else {
                                    return $configSave;
                                }
                            }
                            else {
                                return $queue;
                            }
                        }
                        else
                        {
                            return [
                                'success'   => false,
                                'msg'       => 'invalid "type" provided'
                            ];
                        }
                    }
                    else
                    {
                        return [
                            'success'   => false,
                            'msg'       => $validate['error']
                        ];
                    }
                }
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'shop1' => $shop
            ];
        }
    }

    public function validatePostData($data)
    {
        $required_indexes = ['queue_config_id','queue_name', 'topic', 'type'];

        foreach ($required_indexes as $index) {
            if(strpos($index, '->') === false) {
                if(!isset($data[$index])) {
                    return [
                        'status' => false,
                        'error'  => "'{$index}' is required."
                    ];
                }
            }
            else {
                $expl = explode('->', $index);
                if(!isset($data[$expl[0]][$expl[1]])) {
                    return [
                        'status' => false,
                        'error'  => "'{$expl[0]}[{$expl[1]}]' is required."
                    ];
                }
            }
        }

        if(isset($data['queue_config']))
        {
            $required_indexes = ['queue_config->key', 'queue_config->secret', 'queue_config->region'];

            foreach ($required_indexes as $index) {
                if(strpos($index, '->') === false) {
                    if(!isset($data[$index])) {
                        return [
                            'status' => false,
                            'error'  => "'{$index}' is required."
                        ];
                    }
                }
                else {
                    $expl = explode('->', $index);
                    if(!isset($data[$expl[0]][$expl[1]])) {
                        return [
                            'status' => false,
                            'error'  => "'{$expl[0]}[{$expl[1]}]' is required."
                        ];
                    }
                }
            }
        }

        return ['status' => true];
    }

    public function saveConfig($data)
    {
        try {
            $shop = $this->di->getRegistry()->getCurrentShop();
            $appConfig = $this->di->getRegistry()->getAppConfig();

            $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');

            if (isset($appConfig[$this->getApiMode($data)]['app_id'])){
                $clientSecret = $appConfig[$this->getApiMode($data)]['app_secret'];
                $appId = $appConfig[$this->getApiMode($data)]['app_id'];
            } else {
                $shopUsingAppCode = $this->di->getObjectManager()->get('App\Shopifywebapi\Components\Helper')->getAppShopUsingAppCode($shop['_id'], $appConfig['app_code']);
                if (isset($shopUsingAppCode[0]['apps']['client_secret'])) {
                    $clientSecret = $shopUsingAppCode[0]['apps']['client_secret'];
                    $appId = $shopUsingAppCode[0]['apps']['shopify_app_id'];
                }
            }
            $result = $client->putItem([
                'Item' => [ // REQUIRED
                    'id' => [
                        'N' => (string)$appId, //$id,
                    ],
                    'app_id' => [
                        'S' => (string)$appId,
                    ],
                    'app_secret' => [
                        'S' => $clientSecret,
                    ],
                    'marketplace' => [
                        'S' => $appConfig['marketplace']
                    ]
                ],
                'TableName' => 'apps', // REQUIRED
            ]);



            if(isset($data['queue_config']))
            {
                $result = $client->putItem([
                    'Item' => [ // REQUIRED
                        'id' => [
                            'S' => (string)$data['queue_config_id'],
                        ],
                        'queue_type' => [
                            'S' => (string)$data['type'],
                        ],
                        'app_secret' => [
                            'S' => (string)$data['queue_config']['secret'],
                        ],
                        'app_key' => [
                            'S' => (string)$data['queue_config']['key'],
                        ],
                        'queue_region' => [
                            'S' => (string)$data['queue_config']['region']
                        ],
                        'base_url' => [
                            'S' => (string)$this->getQueueBaseUrl($data['queue_url'])
                        ]
                    ],
                    'TableName' => 'queue_config', // REQUIRED
                ]);
            }
            else
            {
                $result = $client->getItem([
                    'Key' => [ // REQUIRED
                        'id' => [
                            'S' => (string)$data['queue_config_id'],
                        ],
                        
                    ],
                    'TableName' => 'queue_config', // REQUIRED
                ]);

                if(is_null($result->get('Item'))){
                    return [
                        'success' => false,
                        'message' => 'Queue does not exist. Pass existing queue id or pass queue id with queue_config',
                        'code' => 'queue_does_not_exist'
                    ];
                }
            }

            $result = $client->scan([
                'FilterExpression' => "shop_id=:shop_id AND app_id=:app_id AND topic=:topic",
                "ExpressionAttributeValues" => [
                    ":shop_id" => [
                        'N' => (string)$shop['_id']
                    ],
                    ":app_id" => [
                        'N' => (string)$appConfig['_id']
                    ],
                    ":topic" => [
                        'S' => (string)$data['topic']
                    ]
                ],
                'TableName' => 'webhook_config', // REQUIRED
            ]);
            $queueData = $data['queue_data']??[];
            if($result->get('Count') == 0)
            {
                $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
                $autoIncrementId = $mongo->getCounter('sqs_config_id');
                
                $result = $client->putItem([
                    'Item' => [
                        'id' => [
                            'N' => (string)$autoIncrementId,
                        ],
                        'shop_id' => [
                            'N' => (string)$shop['_id'],
                        ],
                        'app_id' => [
                            'N' => (string)$appConfig['_id'],
                        ],
                        'queue_reference_id' => [
                            'S' => (string)$data['queue_config_id'],
                        ],
                        'topic' => [
                            'S' => (string)$data['topic']
                        ],
                        'queue_name' => [
                            'S' => (string)$data['queue_name']
                        ],
                        // 'address' => [
                        //     'S' => (string)$address
                        // ],
                        'queue_data' => [
                            'S' => (string)json_encode($queueData)
                        ]
                    ],
                    'TableName' => 'webhook_config', // REQUIRED
                ]);

                return [
                    'success' => true,
                    'message' => 'Registered Successfully',
                    'id'      => $autoIncrementId
                ];

            }
            else
            {
                $items = $result->get('Items');

                $result = $client->putItem([
                    'Item' => [
                        'id' => [
                            'N' => (string)$items[0]['id']['N'],
                        ],
                        'shop_id' => [
                            'N' => (string)$shop['_id'],
                        ],
                        'app_id' => [
                            'N' => (string)$appConfig['_id'],
                        ],
                        'queue_reference_id' => [
                            'S' => (string)$data['queue_config_id'],
                        ],
                        'topic' => [
                            'S' => (string)$data['topic']
                        ],
                        'queue_name' => [
                            'S' => (string)$data['queue_name']
                        ],
                        // 'address' => [
                        //     'S' => (string)$address
                        // ],
                        'queue_data' => [
                            'S' => (string)json_encode($queueData)
                        ]
                    ],
                    'TableName' => 'webhook_config', // REQUIRED
                ]);
                return [
                    'success' => true,
                    'message' => 'Already Registered',
                    'code' => 'already_registered',
                    'id'    => $items[0]['id']['N'],
                    'queue_data' => $queueData
                ];
            }
        }
        catch (Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage(),
                'shop' => $shop
            ];
        }
    }

    public function getQueueBaseUrl($queue_url)
    {
        $explode = explode('/', $queue_url);
        unset($explode[count($explode)-1]);

        return implode('/', $explode);
    }

    public function getApiMode($request_data)
    {
        if(isset($request_data['sandbox']) && $request_data['sandbox']) $mode = 'sandbox';
        else $mode = 'live';

        return $mode;
    }

    public function getWebhookAddress($id, $data, $baseWebhookUrl)
    {
        $queryParams = [
            'id'    => $id,
            'topic' => str_replace('/', '_', $data['topic'])
        ];

        return $baseWebhookUrl.'?'. http_build_query($queryParams);
    }

    public function unregister($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                if(isset($data['id']))
                {
                    $status = $this->deleteSigleConfig($data);

                    if($status['success']) {
                        $webhookData = [
                            'id'        => $data['id'],
                            'call_type' => ''
                        ];

                        return $this->delete($webhookData);
                    }
                    else {
                        return $status;
                    }
                }
                else
                {
                    $status = $this->deleteAllConfig($data);

                    if($status['success']) {

                        $response = $this->get([]);
                        
                        if (isset($response['success']) && $response['success'] === true) {
                            $data = $response['data'];
                            
                            $webhooks = current($response['data']);

                            $ids = [];
                            foreach ($webhooks as $webhook) {
                                $ids[] = $webhook['id'];
                            }

                            $webhookData = [
                                'ids'        => implode(',', $ids),
                                'call_type' => ''
                            ];

                            return $this->delete($webhookData);
                        }
                        else {
                            return $status;
                        }
                    }
                    else {
                        return $status;
                    }
                }
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function deleteSigleConfig($data)
    {
        try {
            $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');

            $shop = $this->di->getRegistry()->getCurrentShop();
            $appConfig = $this->di->getRegistry()->getAppConfig();

            $result = $client->scan([
                'FilterExpression' => "shop_id=:shop_id AND app_id=:app_id AND topic=:topic",
                "ExpressionAttributeValues" => [
                    ":shop_id" => [
                        'N' => (string)$shop['_id']
                    ],
                    ":app_id" => [
                        'N' => (string)$appConfig['_id']
                    ],
                    ":topic" => [
                        'S' => (string)$data['topic']
                    ]
                ],
                'TableName' => 'webhook_config', // REQUIRED
            ]);
            
           
            if($result->get('Count') > 0)
            {
                foreach($result->get('Items') as $item) {
                      $result = $client->deleteItem([
                        'Key' => [ 
                            'id' => [
                                'N' => (string)$item['id']['N'],
                            ]
                        ],
                        'TableName' => 'webhook_config', // REQUIRED
                    ]);  
                }

                return [
                    'success' => true,
                    'message' => 'Unegistered Successfully',
                ];

            }
            else
            {
                return [
                    'success' => true,
                    'message' => 'Already Unregistered',
                    'code' => 'already_unregistered'
                ];
            }
        }
        catch (Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }

    public function deleteAllConfig()
    {
        try {
            $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');

            $shop = $this->di->getRegistry()->getCurrentShop();
            $appConfig = $this->di->getRegistry()->getAppConfig();

            $result = $client->scan([
                'FilterExpression' => "shop_id=:shop_id AND app_id=:app_id",
                "ExpressionAttributeValues" => [
                    ":shop_id" => [
                        'N' => (string)$shop['_id']
                    ],
                    ":app_id" => [
                        'N' => (string)$appConfig['_id']
                    ]
                ],
                'TableName' => 'webhook_config', // REQUIRED
            ]);
            
           
            if($result->get('Count') > 0)
            {
                foreach($result->get('Items') as $item) {
                      $result = $client->deleteItem([
                        'Key' => [ 
                            'id' => [
                                'N' => (string)$item['id']['N'],
                            ]
                        ],
                        'TableName' => 'webhook_config', // REQUIRED
                    ]);  
                }

                return [
                    'success' => true,
                    'message' => 'Unegistered Successfully',
                ];

            }
            else
            {
                return [
                    'success' => true,
                    'message' => 'Already Unregistered',
                    'code' => 'already_unregistered'
                ];
            }
        }
        catch (Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }

    public function getWebhookConfig($request_data)
    {
        try {
            $callType = $request_data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $request_data = $this->getFilteredParams($request_data);

                if(isset($request_data['id']) || isset($request_data['shop_id']) || isset($request_data['app_id']) || isset($request_data['topic']) || isset($request_data['queue_reference_id'])) {
                    $keys = ['id' => 'N', 'shop_id' => 'N', 'app_id' => 'N', 'topic' => 'S', 'queue_reference_id' => 'S'];

                    $filterExpressionArray = $expressionAttrValueArray = [];
                    foreach ($keys as $key=>$type) {
                        if(isset($request_data[$key])) {
                            $filterExpressionArray[] = "{$key}=:{$key}";
                            $expressionAttrValueArray[":{$key}"] = [
                                $type => (string)$request_data[$key]
                            ];
                        }
                    }

                    if(!empty($filterExpressionArray) && !empty($expressionAttrValueArray)) {
                        $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');
                        $result = $client->scan([
                            'FilterExpression' => implode(' AND ', $filterExpressionArray),
                            "ExpressionAttributeValues" => $expressionAttrValueArray,
                            'TableName' => 'webhook_config',
                        ]);

                        if($result->get('Count') > 0) {
                            return [
                                'success'   => true,
                                'data'      => $result->get('Items')
                            ];
                        }
                        else {
                            return [
                                'success'   => false,
                                'msg'       => 'no data found'
                            ];
                        }
                    }
                    else {
                        return [
                            'success'   => false,
                            'msg'       => 'id or shop_id or app_id or topic or queue_reference_id is required'
                        ];
                    }
                }
                else {
                    return [
                        'success'   => false,
                        'msg'       => 'id or shop_id or app_id or topic or queue_reference_id is required'
                    ];
                }
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}