<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class ShopifyGQL extends Base
{
    protected $_component = 'ShopifyGQL';

    public function query($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                if(isset($data['query'])) {
                    return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\ShopifyGQL\ShopifyGQL')->executeQuery($data['query']);
                }
                else {
                    return [
                        'success' => false,
                        'msg' => 'query is required.'
                    ];
                }
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function mutation($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                if(isset($data['mutation'])) {
                    return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\ShopifyGQL\ShopifyGQL')->executeMutation($data['mutation']);
                }
                else {
                    return [
                        'success' => false,
                        'msg' => 'mutation is required.'
                    ];
                }
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}