<?php

namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Shop extends Base
{
    const IS_EQUAL_TO = 1;
    const IS_NOT_EQUAL_TO = 2;
    const IS_CONTAINS = 3;
    const IS_NOT_CONTAINS = 4;
    const START_FROM = 5;
    const END_FROM = 6;
    const RANGE = 7;

    protected $_component = 'Shop';

    public function get($data)
    {
        try {

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $callType = $data['call_type'] ?? '';

                if($callType == 'ShippingZones')
                {
                    $shopData = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Shop'.$callType)->getShopDetail($data);

                }
                else
                {
                    $shopData = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Shop'.$callType)->getShopDetail();
                }

                if(isset($shopData['success']) && $shopData['success']) {
                    return [
                        'success' => true,
                        'data' => $shopData['data']
                    ];
                }
                else {
                    return [
                        'success' => false,
                        'msg' => $shopData['msg']
                    ];
                }
            }
            else
            {
                die('shop_id not found.');
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getTraceAsString()
            ];
        }
    }

    public function modifyFilterData($data){
        $ar=[];
        foreach ($data as $key=>$value){
            if($key=='user_id'){
                $ar['user_id']=$value[3];
            }
            if($key=='name'){
                $ar['name']=$value[3];
            }
            if($key=='ssd.shop_url'){
                $ar['ssd.shop_url']=$value[3];
            }
            if($key=='email'){
                $ar['email']=$value[3];
            }
            if($key=='status'){
                $ar['status']=$value[3];
            }

        }
        return $ar;
    }

    public static function searchMongo($filterParams = [])
    {
        $conditions = [];
        if (isset($filterParams['filter'])) {
            foreach ($filterParams['filter'] as $key => $value) {
                $key = trim($key);
                if($key!='shop_url'){
                    $key='info.'.$key;
                }
                if($key=='info.user_ids'){
                    $key='user_ids';
                }
                if (array_key_exists(self::IS_EQUAL_TO, $value)) {
                    $conditions[$key] = self::checkInteger($key, $value[self::IS_EQUAL_TO]);
                } elseif (array_key_exists(self::IS_NOT_EQUAL_TO, $value)) {
                    $conditions[$key] =  ['$ne' => self::checkInteger($key, trim($value[self::IS_NOT_EQUAL_TO]))];
                } elseif (array_key_exists(self::IS_CONTAINS, $value)) {
                    $conditions[$key] = [
                        '$regex' =>  self::checkInteger($key, trim(addslashes($value[self::IS_CONTAINS]))),
                        '$options' => 'i'
                    ];
                } elseif (array_key_exists(self::IS_NOT_CONTAINS, $value)) {
                    $conditions[$key] = [
                        '$regex' => "^((?!" . self::checkInteger($key, trim(addslashes($value[self::IS_NOT_CONTAINS]))) . ").)*$",
                        '$options' => 'i'
                    ];
                } elseif (array_key_exists(self::START_FROM, $value)) {
                    $conditions[$key] = [
                        '$regex' => "^" . self::checkInteger($key, trim(addslashes($value[self::START_FROM]))),
                        '$options' => 'i'
                    ];
                } elseif (array_key_exists(self::END_FROM, $value)) {
                    $conditions[$key] = [
                        '$regex' => self::checkInteger($key, trim(addslashes($value[self::END_FROM]))) . "$",
                        '$options' => 'i'
                    ];
                } elseif (array_key_exists(self::RANGE, $value)) {
                    if (trim($value[self::RANGE]['from']) && !trim($value[self::RANGE]['to'])) {
                        $conditions[$key] =  ['$gte' => self::checkInteger($key, trim($value[self::RANGE]['from']))];
                    } elseif (trim($value[self::RANGE]['to']) &&
                        !trim($value[self::RANGE]['from'])) {
                        $conditions[$key] =  ['$lte' => self::checkInteger($key, trim($value[self::RANGE]['to']))];
                    } else {
                        $conditions[$key] =  [
                            '$gte' => self::checkInteger($key, trim($value[self::RANGE]['from'])),
                            '$lte' => self::checkInteger($key, trim($value[self::RANGE]['to']))
                        ];
                    }
                }
                /*if($key == 'variants.quantity'){
                    $conditions[$key] = null;
                }*/
            }
        }
        if (isset($filterParams['search'])) {
            $conditions['$text'] = ['$search' => self::checkInteger($key, trim(addslashes($filterParams['search'])))];
        }
        return $conditions;
    }

    public static function checkInteger($key, $value)
    {
//        if ($key == '_id') {
//            $value = trim($value);
//            return (float)$value;
//        }
        return trim($value);
    }

    public function getFbApprovalStatus($data)
    {

//        return ['success' => true, 'message' => $data];
        try {
//            if($shop = $this->di->getRegistry()->getCurrentShop())
//            {
                $mongoCollection = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
                $mongoCollection->setSource('apps_shop');
                $phpMongoCollection = $mongoCollection->getCollection();
//                $data=$phpMongoCollection->findOne(['sub_apps'=>1,'_id'=>874]);

                $subAppId = isset($data['filters']['sub_apps']) ? (int)$data['filters']['sub_apps'] : 1;
                $page = isset($data['filters']['activePage']) ? (int)$data['filters']['activePage'] : 0;
                $count = isset($data['filters']['count']) ? (int)$data['filters']['count'] : 50;

                $aggregate = [];

                $aggregate[] = ['$project' => ['shop_url' => 1, 'sub_apps' => 1, 'info' => 1]];

                $aggregate[]=['$addFields'=>['user_ids'=>['$toString'=>'$_id']]];

                $filters=isset($data['filters']['filter'])?$data['filters']:[];

                if (isset($filters['filter']) && count($filters['filter'])) {

                    $filters['filter']['sub_apps']=$subAppId;

                    $conditionalQuery = self::searchMongo($filters);

                    $aggregate[]=['$match'=>$conditionalQuery];

                } else {
                    $aggregate[] = ['$match' => ['sub_apps' => $subAppId]];
                }

                $aggregate[] = ['$sort' => [
                    'info.status' => -1,
                    '_id' => -1,
                ]];

                $aggregate[] = ['$skip' => $count * $page];

                $aggregate[] = ['$limit' => $count];

                $invResponse = $phpMongoCollection->aggregate($aggregate);

                $ar=$invResponse->toArray();

                return [
                    'success' => true,
                    'message' => 'fb approval data',
                    'data' => $ar,
//                    'count'=>count($ar),
                    'total' => $phpMongoCollection->count(['sub_apps'=>$subAppId])
                ];
//            }
//            else
//            {
//                return ['success' => false, 'message' => 'Shop Not Found!!'];
//                die('shop_id not found.');
//            }
        } catch (\Exception $exception) {
            return $exception->getMessage();
        }
    }

    public function handleFbApprovalData($postData)
    {
        $shopData = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->getShop(false , false, ["shop_url" => trim($postData['filters']['data']['shop_url'])], ['shop_url']);
        if(isset($shopData['data']['datos']['info'])){
                $info = $shopData['data']['datos']['info'];
                $info['status'] = isset($postData['filters']['data']['status']) ? $postData['filters']['data']['status'] : (isset($info['status']) ? $info['status'] : 'UNDER_REVIEW');
                $info['name'] = isset($postData['filters']['data']['name']) ? $postData['filters']['data']['name'] : (isset($info['name']) ? $info['name'] : '');
                $info['email'] = isset($postData['filters']['data']['email']) ? $postData['filters']['data']['email'] : (isset($info['email']) ? $info['email'] : '');
                $info['category'] = isset($postData['filters']['data']['category']) ? $postData['filters']['data']['category'] : (isset($info['category']) ? $info['category'] : '');
                $info['facebook_id'] = isset($postData['filters']['data']['facebook_id']) ? $postData['filters']['data']['facebook_id']: (isset($info['facebook_id']) ? $info['facebook_id'] : '');
            $info['phone'] = isset($postData['filters']['data']['phone']) ? $postData['filters']['data']['phone']: (isset($info['phone']) ? $info['phone'] : '');

                $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(false, false, [
                    'shop_url' => trim($postData['filters']['data']['shop_url']),
                    'info' => $info
                ],
                    ['shop_url']
                );
                return [
                    'success' => $shop['success'],
                    'type' => 'updated',
                    'email' => $info['email'],
                    'message' => $postData['filters']['data']['status'] ?? ''
                ];

        } else {
            $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(false, false, [
                'shop_url' => trim($postData['filters']['data']['shop_url']),
                'info' => [
                    'name' => $postData['filters']['data']['name'],
                    'email' => $postData['filters']['data']['email'],
                    'category' => $postData['filters']['data']['category'],
                    'facebook_id' => $postData['filters']['data']['facebook_id'],
                    'phone' => isset($postData['filters']['data']['phone']) ? $postData['filters']['data']['phone'] : '',
                    'status' => isset($postData['filters']['data']['status']) ? $postData['filters']['data']['status'] : 'UNDER_REVIEW'
                ]
            ],
                ['shop_url']
            );
            return [
                'success' => $shop['success'],
                'type' => 'created',
                'message' => $shop['message']
            ];
        }
    }

    public function ping($data)
    {
        return $this->get($data);
    }

    // public function hmacValidate($data)
    // {
    //     return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Helper')->validateHmac($data);
    // }

    public function checkMissingAccessScopes($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('App\Shopifywebapi\Components\Shop\Shop')->checkMissingAccessScopes();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function addScript($data)
    {
        if ($shop = $this->di->getRegistry()->getCurrentShop()) {
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Shop')->addScript($data);
        } else {
            return [
                'success' => false,
                'msg' => 'shop_id not found'
            ];
        }
    }
    public function getScripts($data)
    {
        if ($shop = $this->di->getRegistry()->getCurrentShop()) {
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Shop')->getScripts();
        } else {
            return [
                'success' => false,
                'msg' => 'shop_id not found'
            ];
        }
    }
    public function deleteScript($data)
    {
        if ($shop = $this->di->getRegistry()->getCurrentShop()) {
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Shop')->deleteScript($data);
        } else {
            return [
                'success' => false,
                'msg' => 'shop_id not found'
            ];
        }
    }

    public function appUninstall($data)
    {
        try {
            $callType = $data['call_type'] ?? '';
            if ($this->di->getRegistry()->getCurrentShop()) {
                $response = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Shop' . $callType)->appUninstall();
                return $response;
            }
            return [
                'success' => false,
                'message' => 'Shop Not Found',
                'sentdata' => $data
            ];
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}