<?php
namespace App\Shopifywebapi\Api;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class SalesChannel extends Base
{
    protected $_component = 'SalesChannel';

    /*public function getProductListing($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                $request_data = $this->getFilteredParams($request_data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->getProductListing($request_data);
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }*/

    public function getListingProductIds($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                $request_data = $this->getFilteredParams($request_data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->getListingProductIds($request_data);
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    /*public function getProductListingCount($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                // $request_data = $this->getFilteredParams($request_data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->getProductListingCount();
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }*/

    public function createProductListing($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                if(isset($request_data['data']['product_id'])) {
                    $productId = $request_data['data']['product_id'];
                    
                    $productData = ['product_listing' => ['product_id'=>$request_data['data']['product_id']]];

                    $res = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->createProductListing($productId, $productData);
                    
                    return $res;
                }
                else {
                    return ['success' => false, 'msg' => 'product_id is required'];     
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function deleteProductListing($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                if(isset($request_data['id'])) {
                    $productId = $request_data['id'];
                    
                    $res = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->deleteProductListing($productId);
                    return $res;
                }
                else {
                    return ['success' => false, 'msg' => 'id is required'];     
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function getCollectionListing($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                $request_data = $this->getFilteredParams($request_data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->getCollectionListing($request_data);
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function getCollectionProductIds($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                $request_data = $this->getFilteredParams($request_data);

                if(isset($request_data['id'])) {
                    $collectionId = $request_data['id'];
                    unset($request_data['id']);
                    
                    return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->getCollectionProductIds($collectionId, $request_data);
                }
                else {
                    return ['success' => false, 'msg' => 'id is required'];     
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function createCollectionListing($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                if(isset($request_data['data']['collection_id'])) {
                    $collectionId = $request_data['data']['collection_id'];
                    
                    $collectionData = ['collection_listing' => ['collection_id'=>$request_data['data']['collection_id']]];

                    return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->createCollectionListing($collectionId, $productData);                    
                }
                else {
                    return ['success' => false, 'msg' => 'collection_id is required'];     
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function deleteCollectionListing($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                if(isset($request_data['id'])) {
                    $collectionId = $request_data['id'];
                    
                    $res = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->deleteCollectionListing($collectionId);
                    return $res;
                }
                else {
                    return ['success' => false, 'msg' => 'id is required'];     
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function getResourceFeedback($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                // $request_data = $this->getFilteredParams($request_data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->getResourceFeedback();
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function createResourceFeedback($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                
                $postData = $request_data['data'];

                $resource_feedback = [];

                $requiredParams = ['state', 'messages', 'feedback_generated_at'];
                foreach ($requiredParams as $param) {
                    if(!isset($postData[$param])) {
                        return ['success' => false, 'msg' => "{$param} is required"];
                    }
                    elseif($param === 'messages' && !is_array($postData[$param])) {
                        return ['success' => false, 'msg' => "{$param} must be an array"];
                    }

                    $resource_feedback[$param] = $postData[$param];
                }
                
                $resourceFeedbackData = ['resource_feedback' => $resource_feedback];

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->createResourceFeedback($resourceFeedbackData);
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function getProductResourceFeedback($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
            
                // $request_data = $this->getFilteredParams($request_data);

                if(isset($request_data['product_id'])) {
                    $productId = $request_data['product_id'];
                    // unset($request_data['product_id']);
                    
                    return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->getProductResourceFeedback($productId);
                }
                else {
                    return ['success' => false, 'msg' => 'product_id is required'];     
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function createProductResourceFeedback($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                
                $request_data = $this->getFilteredParams($request_data);
                
                if(isset($request_data['product_id'])) {
                    $productId = $request_data['product_id'];
                    unset($request_data['product_id']);
                    
                    $resourceFeedbackData = ['resource_feedback' => $request_data['data']];

                    return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\SalesChannel\SalesChannel')->createProductResourceFeedback($productId, $resourceFeedbackData);                    
                }
                else {
                    return ['success' => false, 'msg' => 'product_id is required'];     
                }
            }
            else {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }
}