<?php
namespace App\Shopifywebapi\Api\Response;

use \App\Apiconnect\Api\Base;

/**
 * Class Product
 * @package App\Shopifywebapi\Components
 */
class Product extends Base
{
    /**
     * @param $response
     * @return string
     */
    public function get($response)
    {
        $formatResponse = [];

        $product_count = $variant_count = 0;
        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];
            if (isset($data['products'])) {
                foreach ($data['products'] as $product) {
                    $formatResponse = array_merge($formatResponse, $this->productFormat($product));
                    $product_count++;
                    $variant_count += count($product['variants']);
                }
                $response['data'] = $formatResponse;
            }
            elseif (isset($data['product'])) {
                $response['data'] = $this->productFormat($data['product']);
                $product_count++;
                $variant_count += count($data['product']['variants']);
            }
            elseif (isset($data['product_listings'])) {
                foreach ($data['product_listings'] as $product) {
                    $this->formatSalesChannelRespose($product);

                    $formatResponse = array_merge($formatResponse, $this->productFormat($product));
                    $product_count++;
                    $variant_count += count($product['variants']);
                }
                $response['data'] = $formatResponse;
            }
            elseif (isset($data['product_listing'])) {
                $product = $data['product_listing'];
                $this->formatSalesChannelRespose($product);

                $response['data'] = $this->productFormat($product);
                $product_count++;
                $variant_count += count($product['variants']);
            }

            $response['count'] = [
                'product' => $product_count,
                'variant' => $variant_count
            ];
        }
        
        return $response;
    }

    protected function productFormat($product)
    {
        $formatted_product['type'] = 'simple';

        $methods = [
            /*'id' => function($product, $value, &$fproduct){
                $fproduct['product_id'] = $value;
            },*/
            'title' => function($product, $value, &$fproduct){
                $fproduct['name'] = $value;
            },
            'body_html' => function($product, $value, &$fproduct){
                $fproduct['description'] = $value;
            },
            'vendor' => function($product, $value, &$fproduct){
                $fproduct['brand'] = $value;
            },
            'variants' => function($product, $value, &$fproduct){
                if(count($value) > 1) {
                    $fproduct['type'] = 'variation';
                }
            },
            'options' => function($product, $value, &$fproduct){
                if ($value[0]['name']==='Title' && $value[0]['values'][0]==='Default Title') {}
                else {
                    foreach ($value as $option) {
                        $fproduct['variant_attributes'][] = $option['name'];
                    }
                }
            },
            'images' => function($product, $value, &$fproduct){
                if(!empty($value)) {
                    foreach ($value as $image) {
                        if($image['src'] !== $product['image']['src'])
                            $fproduct['images'][] = $image['src'];
                    }
                }
            },
            'image' => function($product, $value, &$fproduct){
                $fproduct['main_image'] = $value['src'];
            }
        ];

        foreach($product as $key => $value) {
            if (isset($methods[$key])) {
                $methods[$key]($product, $value, $formatted_product);
            } else {
                $formatted_product[$key] = $value;
            } 
        }

        $result = [];
        foreach($product['variants'] as $variant) {
            // if($variant['sku']!=null){
                $result[] = array_merge($formatted_product, $this->variantFormat($product, $variant, $formatted_product));
            // }
        }

        return $result;
    }

    protected function variantFormat($product, $variant, $formatted_product)
    {
        $formatted_variant = [];

        $methods = [
            'id' => function($product, $value, &$fvariant){
                $fvariant['id'] = $value;
                if(count($product['variants']) > 1) {
                    $fvariant['group_id'] = $product['id'];
                    
                }
                $fvariant['container_id'] = $product['id'];
                
            },
            'product_id' => function($product, $value, &$fvariant){
            },
            'title' => function($product, $value, &$fvariant){
                $fvariant['variant_title'] = $value;
            },
            'price' => function($product, $value, $variant, &$fvariant){
                // if($variant['compare_at_price'] > $variant['price']) {
                //     $fvariant['offer_price'] = $variant['price'];
                // } else {
                //     $fvariant['price'] = $variant['price'];
                // }
                $fvariant['price'] = $variant['price'];
            },
            'compare_at_price' => function($product, $value, $variant, &$fvariant){
                // if($variant['compare_at_price'] > $variant['price']) {
                //     $fvariant['price'] = $variant['compare_at_price'];
                // }
                $fvariant['compare_at_price'] = $variant['compare_at_price'];
            },
            'inventory_quantity' => function($product, $value, &$fvariant){
                $fvariant['quantity'] = $value;
            },
            'image_id' => function($product, $value, &$fvariant){
                foreach ($product['images'] as $image) {
                    if($image['id'] === $value) {
                        $fvariant['variant_image'] = $image['src'];
                        break;
                    }
                }
            },
            'option1' => function($product, $value, $fproduct, &$fvariant){
                if(isset($fproduct['variant_attributes'][0])) {
                    $fvariant[$fproduct['variant_attributes'][0]] = $value;
                }
            },
            'option2' => function($product, $value, $fproduct, &$fvariant){
                if(isset($fproduct['variant_attributes'][1])) {
                    $fvariant[$fproduct['variant_attributes'][1]] = $value;
                }
            },
            'option3' => function($product, $value, $fproduct, &$fvariant){
                if(isset($fproduct['variant_attributes'][2])) {
                    $fvariant[$fproduct['variant_attributes'][2]] = $value;
                }
            },
        ];

        foreach($variant as $key => $value) {
            if (isset($methods[$key])) {
                if(in_array($key, ['option1', 'option2', 'option3'])) {
                    $methods[$key]($product, $value, $formatted_product, $formatted_variant);
                } elseif (in_array($key, ['price', 'compare_at_price'])) {
                    $methods[$key]($product, $value, $variant, $formatted_variant);
                } else {
                    $methods[$key]($product, $value, $formatted_variant);
                }
            } else {
                $formatted_variant[$key] = $value;
            } 
        }

        return $formatted_variant;
    }

    private function formatSalesChannelRespose(&$product)
    {
        if(array_key_exists('id', $product)===false)
            $product['id'] = $product['product_id'];
        
        if(array_key_exists('image', $product)===false)
            $product['image'] = current($product['images']);

        foreach ($product['variants'] as $key => $variant) {
            if(!isset($variant['product_id']))
                $product['variants'][$key]['product_id'] = $product['product_id'];

            if(isset($variant['option_values']) && !empty($variant['option_values'])) {
                foreach ($variant['option_values'] as $option_value_arr) {
                    $product['variants'][$key][$option_value_arr['name']] = $option_value_arr['value'];       
                }

                unset($product['variants'][$key]['option_values']);
            }
        }

        return $product;
    }

    public function getProductCount($response)
    {
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];

            if(isset($data['count'])) {
                $response['data'] = $data['count'];
            }
        }
        
        return $response;
    }
}