<?php
namespace App\Shopifywebapi\Api\Response;

use \App\Apiconnect\Api\Base;

/**
 * Class Product
 * @package App\Shopifywebapi\Components
 */
class Order extends Base
{
    public function get($response)
    {
        $formatResponse = [];
        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];
            if (isset($data['orders']) && $data['orders']) {
                foreach ($data['orders'] as $order) {
                    $formatResponse[] = $this->orderFormat($order);
                }
                $response['data'] = $formatResponse;
            }
            else {
                $response['data'] = $this->orderFormat($data['order']);
            }
        }

        return $response;
    }

    public function create($response)
    {
        $formatResponse = [];
        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];
            if (isset($data['orders']) && $data['orders']) {
                foreach ($data['orders'] as $order) {
                    $formatResponse[] = $this->orderFormat($order);
                }
                $response['data'] = $formatResponse;
            }
            else {
                $response['data'] = $this->orderFormat($data['order']);
            }
        }

        return $response;
    }

    private function orderFormat($order)
    {
        $formatted_order = [];

        $methods = [
            'line_items' => function($order, $value, &$forder){
                $forder['items'] = $value;
            },
            'total_price' => function($order, $value, &$forder){
                $forder['total_amount'] = $value;
            },
            'shipping_lines' => function($order, $value, &$forder){
                if(isset($value[0])) {
                    $forder['shipping_details'] = $value[0];
                } else {
                    $forder['shipping_details'] = $value;
                }

            },
           /* 
            'id' => function($order, $value, &$forder){
                $forder['product_id'] = $value;
            },
            'id' => function($order, $value, &$forder){
                $forder['product_id'] = $value;
            },
            'id' => function($order, $value, &$forder){
                $forder['product_id'] = $value;
            },
            'id' => function($order, $value, &$forder){
                $forder['product_id'] = $value;
            },
            'id' => function($order, $value, &$forder){
                $forder['product_id'] = $value;
            },
            'id' => function($order, $value, &$forder){
                $forder['product_id'] = $value;
            },*/
        ];

        foreach($order as $key => $value) {
            if (isset($methods[$key])) {
                $methods[$key]($order, $value, $formatted_order);
            } else {
                $formatted_order[$key] = $value;
            } 
        }

        return $formatted_order;
    }
}