<?php
namespace App\Shopifywebapi\Api\Response\BulkOperation;

use \App\Apiconnect\Api\Base;

/**
 * Class Bulk
 * @package App\Shopifywebapi\Components
 */
class Product extends Base
{
    public function getBulkItemCount($response)
    {
        if($response['success']) {
            return [
                'success'   => true,
                'data'      => $response['data']['Product']
            ];
        }
        else {
            return $response;
        }
    }

    /**
     * @param $response
     * @return Array
     */
    public function getBulkItem($response)
    {
        // return $response;
        $formatResponse = [];

        $product_count = $variant_count =0;
        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data']['Product'];

            foreach ($data as $product) {
                $formatResponse = array_merge($formatResponse, $this->productFormat($product));
                $product_count++;
                $variant_count += count($product['ProductVariant']);
            }
            $response['data'] = $formatResponse;

            $response['count'] = [
                'product' => $product_count,
                'variant' => $variant_count
            ];
        }
        
        return $response;
    }

    private function productFormat($product)
    {
        $formatted_product['type'] = 'simple';

        $methods = [
            'id' => function($product, $value, &$fproduct){
                $id_info = $this->getIdInfo($value);
                if(count($product['ProductVariant']) > 1) {
                    $fproduct['group_id'] = $id_info['id'];  
                }
                $fproduct['container_id'] = $id_info['id'];
            },
            'title' => function($product, $value, &$fproduct){
                $fproduct['name'] = $value;
            },
            'productType' => function($product, $value, &$fproduct){
                $fproduct['product_type'] = $value;
            },
            'descriptionHtml' => function($product, $value, &$fproduct){
                $fproduct['description'] = $value;
            },
            'description' => function($product, $value, &$fproduct){
                // $fproduct['description_without_html'] = $value;
            },
            'tags' => function($product, $value, &$fproduct){
                $fproduct['tags'] = implode(',', $value);
            },
            'vendor' => function($product, $value, &$fproduct){
                $fproduct['brand'] = $value;
            },
            'ProductVariant' => function($product, $value, &$fproduct){
                if(count($value) > 1) {
                    $fproduct['type'] = 'variation';
                }

                $options = current($value)['selectedOptions'];
                if ($options[0]['name']==='Title' && $options[0]['value']==='Default Title') {}
                else {
                    foreach ($options as $option) {
                        $fproduct['variant_attributes'][] = $option['name'];
                    }
                }
            },
            'ProductImage' => function($product, $value, &$fproduct){
                if(!empty($value)) {
                    foreach ($value as $image) {
                        if($image['id'] !== $product['featuredImage']['id'])
                            $fproduct['images'][] = $image['originalSrc'];
                    }
                }
            },
            'featuredImage' => function($product, $value, &$fproduct){
                $fproduct['main_image'] = $value['originalSrc'];
            },
            'publishedAt' => function($product, $value, &$fproduct){
                $fproduct['published_at'] = $value;
            },
            'createdAt' => function($product, $value, &$fproduct){
                $fproduct['created_at'] = $value;
            },
            'updatedAt' => function($product, $value, &$fproduct){
                $fproduct['updated_at'] = $value;
            },
            'templateSuffix' => function($product, $value, &$fproduct){
                $fproduct['template_suffix'] = $value;
            }
        ];

        foreach($product as $key => $value) {
            if (isset($methods[$key])) {
                $methods[$key]($product, $value, $formatted_product);
            } else {
                $formatted_product[$key] = $value;
            } 
        }

        $result = [];
        foreach($product['ProductVariant'] as $variant) {
            $result[] = array_merge($formatted_product, $this->variantFormat($product, $variant, $formatted_product));
        }

        return $result;
    }

    private function variantFormat($product, $variant, $formatted_product)
    {
        $formatted_variant = [];

        $methods = [
            'id' => function($product, $value, &$fvariant){
                $fvariant['id'] = $this->getIdInfo($value)['id'];
            },
            '__parentId' => function($product, $value, &$fvariant){
            },
            'title' => function($product, $value, &$fvariant){
                $fvariant['variant_title'] = $value;
            },
            'price' => function($product, $value, $variant, &$fvariant){
                // if($variant['compareAtPrice'] > $variant['price']) {
                //     $fvariant['offer_price'] = $variant['price'];
                // } else {
                //     $fvariant['price'] = $variant['price'];
                // }
                $fvariant['price'] = $variant['price'];
            },
            'compareAtPrice' => function($product, $value, $variant, &$fvariant){
                // if($variant['compareAtPrice'] > $variant['price']) {
                //     $fvariant['price'] = $variant['compareAtPrice'];
                // }
                $fvariant['compare_at_price'] = $variant['compareAtPrice'];
            },
            'inventoryQuantity' => function($product, $value, &$fvariant){
                $fvariant['quantity'] = $value;
            },
            'fulfillmentService' => function($product, $value, &$fvariant){
                $fvariant['fulfillment_service'] = $value['handle'];
            },
            'image' => function($product, $value, &$fvariant){
                $fvariant['variant_image'] = $value['originalSrc'];
            },
            'selectedOptions' => function($product, $value, &$fvariant){
                if ($value[0]['name']!=='Title' && $value[0]['value']!=='Default Title') {
                    foreach ($value as $option) {
                        $fvariant[$option['name']] = $option['value'];
                    }
                }
            },
            'inventoryItem' => function($product, $value, &$fvariant){
                $fvariant['inventory_item_id']      = $this->getIdInfo($value['id'])['id'];
                // $fvariant['inventory_management']   = $value['tracked'];
                $fvariant['inventory_tracked']      = $value['tracked'];
                $fvariant['requires_shipping']      = $value['requiresShipping'];
            },
            'InventoryLevel' => function($product, $value, &$fvariant){
                $inventory_levels = [];
                foreach ($value as $inventoryLevel) {
                    $inventory_level = [
                        'admin_graphql_api_id' => $inventoryLevel['id'],
                        'updated_at'           => $inventoryLevel['updatedAt'],
                        'available'            => $inventoryLevel['available'],
                        'location'             => $inventoryLevel['location']
                    ];

                    $inventory_level['location']['id'] = $this->getIdInfo($inventoryLevel['location']['id'])['id'];

                    $inventory_levels[] = $inventory_level;
                }

                $fvariant['inventory_levels'] = $inventory_levels;
            },
             'createdAt' => function($product, $value, &$fvariant){
                $fvariant['created_at'] = $value;
            },
            'updatedAt' => function($product, $value, &$fvariant){
                $fvariant['updated_at'] = $value;
            },
            'inventoryPolicy' => function($product, $value, &$fvariant){
                $fvariant['inventory_policy'] = $value;
            },
            'weightUnit' => function($product, $value, $variant, &$fvariant){
                $fvariant['weight_unit'] = $value;
                $fvariant['grams'] = $this->convertWeightInGram($value, $variant['weight']);
            }
        ];

        foreach($variant as $key => $value) {
            if (isset($methods[$key])) {
                if (in_array($key, ['price', 'compareAtPrice', 'weightUnit'])) {
                    $methods[$key]($product, $value, $variant, $formatted_variant);
                } else {
                    $methods[$key]($product, $value, $formatted_variant);
                }
            } else {
                $formatted_variant[$key] = $value;
            } 
        }

        return $formatted_variant;
    }

    private function getIdInfo($id)
    {
        if(($pos = strpos($id, '?')) !== false) {
            $id = substr($id, 0, $pos);
        }

        $id = str_replace('gid://shopify/', '', $id);

        $id_info = explode('/', $id);

        return [
            'type'  => $id_info[0],
            'id'    => $id_info[1]
        ];
    }

    private function convertWeightInGram($unit, $weight)
    {
        $grams = null;

        switch ($unit) {
            case 'KILOGRAMS':
                $grams = $weight * 1000;
                break;
            
            case 'GRAMS':
                $grams = $weight;
                break;

            case 'POUNDS':
                $grams = $weight * 453.6;
                break;

            case 'OUNCES':
                $grams = $weight * 28.3;
                break;
        }

        return $grams;
    }
}