<?php
namespace App\Shopifywebapi\Api\Response\Billing;

use \App\Apiconnect\Api\Base;

/**
 * Class Product
 * @package App\Shopifywebapi\Components
 */
class Recurring extends Base
{
    /**
     * @param $response
     * @return string
     */
    public function get($response)
    {        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];

            if(isset($data['recurring_application_charge']) || isset($data['recurring_application_charges'])) {
                $response['data'] = $data['recurring_application_charge']??$data['recurring_application_charges'];
            }
        }
        
        return $response;
    }

    public function create($response)
    {        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];
            
            if(isset($data['recurring_application_charge']) || isset($data['recurring_application_charges'])) {
                $response['data'] = $data['recurring_application_charge']??$data['recurring_application_charges'];
            }
        }
        
        return $response;
    }

    public function update($response)
    {        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];
            
            if(isset($response['data']['recurring_application_charge']) || isset($response['data']['recurring_application_charges'])) {
                $response['data'] = $data['recurring_application_charge']??$data['recurring_application_charges'];
            }
        }
        
        return $response;
    }

    /**
     * @param $response
     * @return string
     */
    public function activate($response)
    {        
        if (isset($response['success']) && $response['success'] === true) {
            $data = $response['data'];
            
            if(isset($data['recurring_application_charge']) || isset($data['recurring_application_charges'])) {
                $response['data'] = $data['recurring_application_charge']??$data['recurring_application_charges'];
            }
        }
        
        return $response;
    }
}