<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Product extends Base
{
    protected $_component = 'Product';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                // $default_params = ['_url', 'appId', 'shop_id'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\Product'.$callType)->getShopifyProducts($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getProductAttributes($data)
    {
        try {
            $callType = 'QL';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                // $default_params = ['_url', 'appId', 'shop_id'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\Product'.$callType)->getProductAttributes($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getProductCount($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\Product')->getProductCount();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function createProductMetafields($data){
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\Product'.$callType)->productMetafields($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getProductMetafields($data){
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);
                foreach($data['id'] as $productId){
                    $request['id'] = (string)$productId;
                    $response[] = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\Product'.$callType)->productMetafields($request);
                }
                return ['success' => true, 'data' => $response];
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function create($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $productData = ['product' => $data['data']];
                
                $res = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\Product'.$callType)->createShopifyProduct($productData);
                
                return $res;
            }
            else
            {
                return ['success' => false, 'msg' => 'shop_id not found'];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function update($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                if(isset($data['data']['id'])) {
                    $productId = $data['data']['id'];
                    // unset($data['data']['id']);
                    
                    $productData = ['product' => $data['data']];
                    $res = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->updateShopifyProduct($productId, $productData);
                    return $res;
                }
                else {
                    return ['success' => false, 'msg' => 'id of product is required'];     
                }
            }
            else
            {
                return ['success' => false, 'msg' => 'shop_id not found'];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getProductWithVariantCount($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Product\Product')->getProductWithVariantCount();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}