<?php

namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;
/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Order extends Base
{
    protected $_component = 'Order';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                // $default_params = ['_url', 'appId', 'shop_id'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->getShopifyOrders($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function delete($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->deleteShopifyOrders($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function create($data)
    {
        try {
            $callType = $data['call_type'] ?? '';
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $orderData = ['order' => $data['data']];
                // $rateres= $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Ratelimit')->ratelimit($data['shop_id']);
                $res=$this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->createShopifyOrder($orderData);
                // $res['calldata']=$rateres;
                return $res;
            }
            else
            {
            	return [
                    'success'   => false,
                    'msg'       => 'Shop Not Found',
                    'sentdata' => $data
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function update($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                if(isset($data['data']['id'])) {
                    $orderId = $data['data']['id'];
                    // unset($data['data']['id']);

                    $orderData = ['order' => $data['data']];
                    // $rateres = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Ratelimit')->ratelimit($data['shop_id']);
                    $res = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->updateShopifyOrder($orderId, $orderData);
                    // $res['calldata'] = $rateres;

                    return $res;
                }
                else {
                    return ['success' => false, 'msg' => 'id of order is required'];     
                }
            }
            else
            {
                return ['success' => false, 'msg' => 'shop_id not found'];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }


    public function getOrderCount($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->getOrderCount();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getordershipment($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->getordershipment($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];

            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function orderCancel($data)
    {
        if(!isset($data['order_id'])) {
            return [
                'success'   => false,
                'msg'       => 'order_id not found'
            ];       
        }
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
               
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order'.$callType)->orderCancel($data['order_id'], $data['data']);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];

            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function fulfillmentOrder($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if ($this->di->getRegistry()->getCurrentShop()) {
                if (!isset($data['order_id'])) {
                    return [
                        'success' => false,
                        'message' => 'order_id not found'
                    ];
                }
                $data = $this->getFilteredParams($data);
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order' . $callType)->getFulfillmentOrderData($data);
            }
            return [
                'success' => false,
                'message' => 'Shop Not Found'
            ];
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    public function fulfillOrder($data)
    {
        try {
            $callType = $data['call_type'] ?? '';
            if ($this->di->getRegistry()->getCurrentShop()) {
                $shipmentData = ['fulfillment' => $data['fulfillment']];
                $response = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Order\Order' . $callType)->fulfillOrderOnShopify($shipmentData);
                return $response;
            }
            return [
                'success' => false,
                'message' => 'Shop Not Found',
                'sentdata' => $data
            ];
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}