<?php
namespace App\Shopifywebapi\Api;
use Aws\DynamoDb\DynamoDbClient;
use App\Shopifywebapi\Api\Fulfillment as ApiFulfillment;

class Notification extends Base
{
    protected $_component = 'Notification';

    public function createDestination($data){
        try{
            $appConfig =  $this->di->getRegistry()->getAppConfig();
            $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);

            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array']
            ];
            $collection = $model->getCollection('marketplace_destination');
            $handler = $this->di->getObjectManager()->get('App\\'.$targetMarketplace.'\\Api\Base');
            $uniqueKeys = $handler->getDestinationUniqueKeys();
            foreach ($uniqueKeys as $key) {
                if (isset($data['event_data'][$key])) {
                    $filters["{$key}"] = $data['event_data'][$key];
                }
            }
            $marketplace_destination = $collection->findOne($filters, $options);

            if (empty($marketplace_destination)){
                    $destinationId = "test_destination_id";
                    if ($destinationId){
                        $insertData = [
                            '_id' => $model->getCounter('marketplace_destination_id'),
                            'title' =>$data['event_data']['title'] ?? "",
                            'type' => $data['event_data']['type'],
                            'event_handler' => $data['event_data']['event_handler'],
                            'destination_id'=> $destinationId
                        ];
                        $collection->insertOne($insertData);
                        return ['success'=>true,'destination_id'=>$destinationId,'message'=>"Marketplace destination created successfully"];
                    }
            }else{
                return ['success'=>true,'destination_id'=>$marketplace_destination['destination_id'],'message'=>"Marketplace destination already created"];
            }
        }
        catch(\Exception $e){
            return [
                'success' => false,
                'data' => $data,
                'msg' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }

    public function createSubscription($data){
        $shop = $this->di->getRegistry()->getCurrentShop();
        $appConfig = $this->di->getRegistry()->getAppConfig();
        $app_shop = $this->di->getObjectManager()->get('App\Apiconnect\Models\Apps\Shop')->getAppInShopById($shop['_id'], $appConfig['_id']);

        if(isset($app_shop['cif_app_id']) && isset($app_shop['shopify_app_id']) && isset($app_shop['client_secret'])) {
            $id = $app_shop['cif_app_id'];
            $appId = $app_shop['shopify_app_id'];
            $clientSecret = $app_shop['client_secret'];
        }elseif (isset($appConfig[$this->getApiMode($data)]['app_id'])){
            $id = $appConfig['_id'];
            $appId = $appConfig[$this->getApiMode($data)]['app_id'];
            $clientSecret = $appConfig[$this->getApiMode($data)]['app_secret'];
        }
        $prefix = $this->di->getConfig()->get('add_dynamo_prefix') ? $this->di->getConfig()->get('app_code') : "";
        $tableName = empty($prefix) ? "apps" : $prefix . "_apps";

        $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');
        $client->putItem([
            'Item' => [ // REQUIRED
                'id' => [
                    'N' => (string)$id,
                ],
                'app_id' => [
                    'S' => (string)$appId,
                ],
                'app_secret' => [
                    'S' => $clientSecret,
                ],
                'marketplace' => [
                    'S' => $appConfig['marketplace']
                ]
            ],
            'TableName' => $tableName, // REQUIRED
        ]);
        if (!empty($data['marketplace_data']) && isset($data['marketplace_data']['call_type'])) {
            if ($data['marketplace_data']['call_type'] == 'QL') {
                return $this->createSubscriptionQL($data, $appConfig);
            }
        }
        $updatedBaseWebhookUrl = $this->di->getConfig()->get('updated_base_webhook_url');
        if (isset($updatedBaseWebhookUrl)) {
            $baseWebhookUrl = $this->di->getConfig()->get('updated_base_webhook_url')->get($appConfig['marketplace']);
        }
        if(!isset($updatedBaseWebhookUrl,$baseWebhookUrl)) {
            $this->di->getLog()->logContent(date('c').' updated_base_webhook_url key is missing in config or inside update_base_webhook_url array lambda url is missing ','critical','shopify/subs_create.log');
            return ['success' => false, 'message' => 'updated_base_webhook_url key is missing in config or inside update_base_webhook_url array lambda url is missing'];
        }

        $fulfillmentInstance = $this->di->getObjectManager()->get(ApiFulfillment::class);

        if ($fulfillmentInstance->isFulfillmentServiceEventCode($data, $appConfig)) {
            $serviceResponse = $fulfillmentInstance->createFulfillment($data);
            if (!empty($serviceResponse['data']['fulfillment_service']['id'])) {
                return [
                    'success' => $serviceResponse['success'],
                    'subscription_id' =>  $serviceResponse['data']['fulfillment_service']['id']
                ];
            }

            return [
                'success' => false,
                'message' => $serviceResponse['msg'] ?? ($serviceResponse['message'] ?? 'Unexpected Error Occured!')
            ];
        }
        
        $webhookData = [
            'webhook'      => [
                'topic'     => $data['event_code'],
                'address'   => empty($prefix) ? (isset($data['app_code']) ? $baseWebhookUrl."?shop_id=".$shop['_id']."&topic=".$data['event_code']."&app_code=".$data['app_code'] : $baseWebhookUrl."?shop_id=".$shop['_id']."&topic=".$data['event_code']) : (isset($data['app_code']) ? $baseWebhookUrl."?shop_id=".$shop['_id']."&topic=".$data['event_code']."&app_code=".$data['app_code'] . "&prefix=". $prefix : $baseWebhookUrl."?shop_id=".$shop['_id']."&topic=".$data['event_code']. "&prefix=". $prefix),
                'format'    => 'json'
            ]
        ];

        $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\Webhook');
        $response = $object->createWebhook($webhookData);
        $this->di->getLog()->logContent(date('c').' shopify response = '.print_r($response,true)." webhookData = ".print_r($webhookData,true),'critical','shopify/subs_create.log');
        if ($response['success']) return ['success'=>true,'subscription_id'=>$response['data']['webhook']['id'] ?? null];
        return ['success' => false, 'message' => $response['msg']['errors']??'webhook could not be created!'];
    }

    public function createSubscriptionQL($data, $appConfig)
    {
        $this->di->getLog()->logContent('Starting Process for remote_shop_id: ' . $data['shop_id'], 'info', 'shopify/subs_create.log');
        $graphqlBaseUrl = $this->di->getConfig()->get('graphql_base_url');
        if (isset($graphqlBaseUrl)) {
            $baseWebhookUrl = $this->di->getConfig()->get('graphql_base_url')->get($appConfig['marketplace']);
        }
        if (!isset($graphqlBaseUrl, $baseWebhookUrl)) {
            $message = 'graphql_base_url key is missing in config or inside graphql_base_url array lambda url is missing';
            $this->di->getLog()->logContent('Config Error: ' . $message, 'critical', 'shopify/subs_create.log');
            return ['success' => false, 'message' => $message];
        }
        $getWebhookConfig = $this->di->getConfig()->webhooks->get($appConfig['marketplace'])->toArray();
        $eventCode = '';
        if ($data['event_code'] == 'app/uninstalled') {
            $eventCode = 'app_uninstalled';
        } else {
            foreach ($getWebhookConfig as $webhook) {
                if ($data['event_code'] == $webhook['topic']) {
                    $eventCode = $webhook['code'];
                    break;
                }
            }
        }
        if (!empty($eventCode)) {
            $query = '
            mutation {
                eventBridgeWebhookSubscriptionCreate(
                  topic: ' . strtoupper($eventCode) . '
                  webhookSubscription: {
                    arn: "' . $baseWebhookUrl . '"
                    format: JSON
                  }
                ) {
                  webhookSubscription {
                    id
                  }
                  userErrors {
                    message
                  }
                }
              }';
            $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\ShopifyGQL\ShopifyGQL');
            $response = $object->executeMutation($query);
            $this->di->getLog()->logContent('Shopify Response: ' . json_encode($response) . " ,Query: " . print_r($query, true), 'critical', 'shopify/subs_create.log');
            if (isset($response['success']) && $response['success']) {
                if (isset($response['data']['id'])) {
                    $parts = explode('/', $response['data']['id']);
                    $filteredParts = array_filter($parts);
                    $subscriptionId = end($filteredParts);
                    return ['success' => true, 'subscription_id' => $subscriptionId ?? null];
                }
            }
        }
        return ['success' => false, 'message' => $response['message'] ?? 'webhook could not be created!'];
    }

    public function getApiMode($request_data)
    {
        if(isset($request_data['sandbox']) && $request_data['sandbox']) $mode = 'sandbox';
        else $mode = 'live';

        return $mode;
    }

    public function deleteSubscription($data){
        $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Webhook\Webhook');
        $response = $object->deleteWebhook(['id'=>$data['subscription_id']]);
        $this->di->getLog()->logContent('shopify response = '.print_r($response,true)." webhookData = ".print_r($data,true),'critical','shopify/subs_delete.log');
        if (isset($response['success']) && $response['success']){
            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $collection = $model->getCollection('marketplace_subscription');
            $collection->deleteOne(
                ['marketplace_subscription_id' => (string)$data['subscription_id']]
            );
            return ['success'=>true,"message"=>"Marketplace subscription deleted successfully"];
        }else{
            return ['success'=>true,"message"=>"Something went wrong in deleting marketplace subscription"];
        }
    }

}

