<?php
namespace App\Shopifywebapi\Api;

use Exception;
use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Location extends Base
{
    protected $_component = 'Location';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $location_id = null;
                if(isset($data['id'])) {
                    $location_id = $data['id'];
                }
                
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Location'.$callType)->getLocations($location_id);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (Exception $exception) {
            return [
                'success'   => false,
                'msg'       => $exception->getMessage()
            ];
        }
    }

    public function getInventory($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $location_id = $data['location_id'];

                // $default_params = ['_url', 'appId', 'shop_id'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Shop\Location'.$callType)->getLocationInventory($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}