<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Inventory extends Base
{
    protected $_component = 'Inventory';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if ($shop = $this->di->getRegistry()->getCurrentShop()) {

                if (isset($data['location_ids']) || isset($data['inventory_item_ids'])) {
                    if (isset($data['inventory_item_ids'])) {
                        $data['inventory_item_ids'] = implode(',', $data['inventory_item_ids']);
                    }

                    if (isset($data['location_ids'])) {
                        $data['location_ids'] = implode(',', $data['location_ids']);
                    }

                    // $default_params = ['_url', 'appId', 'shop_id', 'sAppId'];
                    // foreach ($default_params as $key) {
                    //     unset($data[$key]);
                    // }
                    $data = $this->getFilteredParams($data);

                    return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Inventory\Inventory' . $callType)->getInventoryLevels($data);
                } else {
                    return [
                        'success' => false,
                        'msg' => 'location_ids OR inventory_item_ids is required.'
                    ];
                }
            } else {
                return [
                    'success' => false,
                    'msg' => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function setInventoryLevels($params)
    {
        try{
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Inventory\Inventory')->setInventoryLevels($params);
        }
        catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }

    }

    public function connectInventoryLevels($params)
    {
        try{
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Inventory\Inventory')->connectInventoryLevels($params);
        }
        catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }

    }
}