<?php
namespace App\Shopifywebapi\Api;

use App\Shopifywebapi\Components\Fulfillment\Fulfillment as FulfillmentFulfillment;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Fulfillment extends Base
{
    protected $_component = 'Fulfillment';
    
    /**
     * Creates a new fulfillment
     *
     * @param array $data
     * @return array
     */
    public function createFulfillment($data = [])
    {
        try {
            $shop      = $this->di->getRegistry()->getCurrentShop();
            $appConfig = $this->di->getRegistry()->getAppConfig();

            $fulfillmentServices =
                !empty($this->di->getConfig()->get('fulfillment_service')->get($appConfig['marketplace']))
                ? $this->di->getConfig()->get('fulfillment_service')->get($appConfig['marketplace'])->toArray()
                : [];

            $baseUrl = !empty($this->di->getConfig()->get('updated_base_webhook_url')->get($appConfig['marketplace']))
            ? $this->di->getConfig()->get('updated_base_webhook_url')->get($appConfig['marketplace'])
            : false;

            if (
                empty($shop['_id'])
                || empty($appConfig)
                || empty($data['event_code'])
                || empty($fulfillmentServices['name'])
                || empty($baseUrl)
            ) {
                return [
                    'success' => false,
                    'message' => 'Shop ID is missing or Data is invalid or Fulfillment Service Name not found!'
                ];
            }

            $callBackUrl = $this->createCallBackUrl($data, $shop['_id'], $baseUrl);

            $fulfillmentServicesName = empty($fulfillmentServices['add_shop_id'])
                ? $fulfillmentServices['name']
                : $fulfillmentServices['name'] . '_' . $shop['_id'];
            
            $preparedData = [
                'fulfillment_service' => [
                    'name'                      => $fulfillmentServicesName,
                    'callback_url'              => $fulfillmentServices['callback_url'] ?? $callBackUrl,
                    'inventory_management'      => $fulfillmentServices['inventory_management'] ?? true,
                    'tracking_support'          => $fulfillmentServices['tracking_support'] ?? true,
                    'requires_shipping_method'  => $fulfillmentServices['requires_shipping_method'] ?? true,
                    'format'                    => $fulfillmentServices['format'] ?? 'json',
                    'permits_sku_sharing'       => $fulfillmentServices['permits_sku_sharing'] ?? true,
                    'fulfillment_orders_opt_in' => $fulfillmentServices['fulfillment_orders_opt_in'] ?? true
                ]
            ];

            return $this->di->getObjectManager()->get(FulfillmentFulfillment::class)
            ->createfulfillmentServices($preparedData);
        } catch (\Exception $e) {
            return [
                'success'  => false,
                'data'     => $data,
                'response' => $e->getMessage(),
                'trace'    => $e->getTraceAsString()
            ];
        }
    }


    public function cancelFulfillment($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfilment_id = $data['fulfillment_id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->cancelfulfillmentServices($data,$fulfilment_id);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function rejectingFulfillmentRequest($data)
    {
        try {
            if(isset($data) && !empty($data)){
                $fulfillment_order_id = $data['id'];
                $data['fulfillment_request']['message'] = $data['message'] ?? 'Order cannot cbe created on MCF';
               
                $result = $this->di->getObjectManager()->get(FulfillmentFulfillment::class)
                    ->rejectFulfillment($fulfillment_order_id, $data);
                return $result;
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function acceptingFulfillmentRequest($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfillment_order_id = $data['fulfillment_order_id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->acceptingfulfillmentrequest($data,$fulfillment_order_id);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function acceptCancellationRequest($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfillment_order_id = $data['fulfillment_order_id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->acceptcancellationrequest($data,$fulfillment_order_id);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function rejectCancellationRequest($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfillment_order_id = $data['id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->rejectcancellationrequest($data,$fulfillment_order_id);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function closeFulfillmentOrder($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfillment_order_id = $data['fulfillment_order_id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->closefulfillmentorder($data,$fulfillment_order_id);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function assignedFulfillmentOrder($data){
        try {
            if(isset($data) && !empty($data)){
                
                $status = $data['fulfillment_order_id'];
                $location_id = $data['location_id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->assignedfulfillmentorder($status,$location_id);
            }else{
                return [
                    'success' => false,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function assignedFulfillments($data){
        try {
            if(isset($data) && !empty($data)){
                
                $status = $data['assignment_status'];
                $location_id = $data['location_ids'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->assignedfulfillments($data);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function acceptFulfillmentOrder($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfillmentOrderId = $data['id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->acceptfulfillmentorder($fulfillmentOrderId);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }

    }
    public function rejectFulfillmentOrder($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfilment_orderId = $data['id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->rejectfulfillmentorder($fulfilment_orderId);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
        // acceptfulfillmentorder
    }
    public function cancellFulfillmentOrder($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfilment_orderId = $data['id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->cancellfulfillmentorder($fulfilment_orderId);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
        // acceptfulfillmentorder
    }
    public function getOrders($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfilment_orderId = $data['id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->getOrderFulfillmentOrder($fulfilment_orderId);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function updateTracking($data)
    {
        try {
            if(isset($data) && !empty($data)){
                $fulfillmentID = $data['fulfillment_id'] ?? false;
                $body = $data['payload'] ?? false;
                if($fulfillmentID && $body){
                    
                    // $fulfilment_orderId = $data['id'];
                    $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                    return $helper->updateTrackingDetails($fulfillmentID,$body);
                }else{
                    return [
                        'success' => false,
                        'data' => $data,
                        'response' => 'Required data not found '
                    ];
                }
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }

    }
    public function getFulfillmentServices($data)
    {
        try{
            if(isset($data) && !empty($data)){
                $id = $data['id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->getFulfillmentServices($id);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
        }
        catch(\Exception $e){
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    public function createfulfillments($data){
        try {
            if(isset($data['payload']) && !empty($data['payload'])){
                $payload = $data['payload'] ?? false; 

                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->createFulfillments($payload);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }
                
        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }
    /**
     * Checks whether the particular event code is fufillment service or not.
     *
     * @param array $eventData
     * @param array $appConfig
     * @return boolean
     */
    public function isFulfillmentServiceEventCode($eventData, $appConfig)
    {
        if (empty($eventData['event_code']) && empty($appConfig['marketplace'])) {
            return false;
        }

        $marketplaceWebhookConfig = !empty($this->di->getConfig()->get('webhooks')->get($appConfig['marketplace']))
        ? $this->di->getConfig()->get('webhooks')->get($appConfig['marketplace'])->toArray() : [];

        foreach ($marketplaceWebhookConfig as $webhook) {
            if (
                !empty($webhook['code'])
                && $webhook['code'] === $eventData['event_code']
                && isset($webhook['fulfillment_service']) && $webhook['fulfillment_service'] === true
            ) {
                return true;
            }
        }

        return false;
    }

    /**
     * Constructing the callback URL based on conditions
     *
     * @param array $data
     * @param string $shopId
     * @param string $baseWebhookUrl
     * @return void
     */
    public function createCallBackUrl($data, $shopId, $baseWebhookUrl)
    {
        $prefix = $this->di->getConfig()->get('add_dynamo_prefix')
        ? $this->di->getConfig()->get('app_code') : "";

        $queryParams = [
            'shop_id' => $shopId,
            'topic' => $data['event_code']
        ];

        if (!empty($data['app_code'])) {
            $queryParams['app_code'] = $data['app_code'];
        }

        if (!empty($prefix)) {
            $queryParams['prefix'] = $prefix;
        }

        $joiner = $baseWebhookUrl[strlen($baseWebhookUrl) - 1] == '/' ? '?' : '/?';

        // Adding fulfillment type in the end cause shopify appends fulfillment type in the url
        // Ex - <callback_url>/fulfillment_order_notification

        // So if we don't add any extra params it will append it in the last query param
        return $baseWebhookUrl . $joiner . http_build_query($queryParams) . '&fulfillment_type=';
    }


    public function fulfillmentOrdersCancel($data){
        try {
            if(isset($data) && !empty($data)){
//                $fulfilment_id = $data['fulfillment_order_id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->fulfillmentOrdersCancel($data);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found '
                ];
            }

        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }
    }

    public function deleteFulfillmentServices($data){
        try {
            if(isset($data) && !empty($data)){
                $fulfillmentServiceId = $data['fulfillment_service_id'];
                $helper = $this->di->getObjectManager()->get(FulfillmentFulfillment::class);
                return $helper->deleteFulfillmentServices($fulfillmentServiceId);
            }else{
                return [
                    'success' => false,
                    'data' => $data,
                    'response' => 'Required data not found for deleting fulfillment service'
                ];
            }

        } catch (\Exception $e) {
            return [
                'success' => false,
                'response' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ];
        }

    }
}