<?php
namespace App\Shopifywebapi\Api;

class Files extends Base
{
    protected $_component = 'Files';


    public function getFileUrlUsingId($data)
    {
        try {
            $shop = $this->di->getRegistry()->getCurrentShop();
            if (!$shop) {
                return [
                    'success' => false,
                    'message' => 'shop_id not found'
                ];
            }
            if (!isset($data['id'])) {
                return [
                    'success' => false,
                    'message' => 'id parameter required'
                ];
            }
            $callType = $data['call_type'] ?? '';
            $data = $this->getFilteredParams($data);
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Files\Files'.$callType)
                ->getFileUrlUsingId($data);

        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }


    public function commenceStagedUploadsCreate($data)
    {
        try {
            $shop = $this->di->getRegistry()->getCurrentShop();
            if (!$shop) {
                return [
                    'success' => false,
                    'message' => 'shop_id not found'
                ];
            }
            $callType = $data['call_type'] ?? '';
            $data = $this->getFilteredParams($data);
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Files\Files'.$callType)
                ->commenceStagedUploadsCreate($data);

        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    public function stagedUploadsCreate($data)
    {
        try {
            $shop = $this->di->getRegistry()->getCurrentShop();
            if (!$shop) {
                return [
                    'success' => false,
                    'message' => 'shop_id not found'
                ];
            }
            $callType = $data['call_type'] ?? '';
            $data = $this->getFilteredParams($data);
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Files\Files'.$callType)
                ->stagedUploadsCreate($data);

        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    public function createFileOnShopify($data)
    {
        try {
            $shop = $this->di->getRegistry()->getCurrentShop();
            if (!$shop) {
                return [
                    'success' => false,
                    'message' => 'shop_id not found'
                ];
            }
            $callType = $data['call_type'] ?? '';
            $data = $this->getFilteredParams($data);
            return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Files\Files'.$callType)
                ->createFileOnShopify($data);

        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}