<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Customer extends Base
{
    protected $_component = 'Customer';

    public function getCustomerCount()
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Customer\Customer')->getCustomerCount();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getShopifyCustomers()
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Customer\Customer')->getShopifyCustomers();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getShopifyCustomerGroups()
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Customer\Customer')->getShopifyCustomerGroups();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getCustomerAddress($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Customer\Customer')->getCustomerAddress($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getAllOrdersPlacedByCustomer($data){
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()){
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Customer\Customer')->getAllOrdersPlacedByCustomer($data);
            }else{
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}