<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Collection extends Base
{
    protected $_component = 'Collection';

    public function get($data)
    {
        try {
            // $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                if(isset($data['ids'])) {
                    $data['ids'] = implode(',', $data['ids']);
                }

                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Collection\Collection')->getCollections($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getCollectionCount()
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Collection\Collection')->getCollectionCount();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }


    public function getAllCollections($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);
                if (isset($data['product_id'])) {
                    $collectionResponse = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Collection\Collection')->getAllCollectionsUsingProductId($data['product_id']);
                    
                    return [
                        'success' => true,
                        'data' => $collectionResponse
                    ];
                }
            }
            
            return [
                'success'   => false,
                'msg'       => 'shop_id or product_id not found'
            ];
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}