<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Checkout extends Base
{
    protected $_component = 'Checkout';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);
                
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Checkout\Checkout'.$callType)->getAbandonedCheckouts($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getcount($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                $data = $this->getFilteredParams($data);
                
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Checkout\Checkout'.$callType)->getcount($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}