<?php
namespace App\Shopifywebapi\Api;

use Phalcon\Events\Event;
use App\Shopifywebapi\Components\BulkOperation\Parser\JSONLParser;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class BulkOperation extends Base
{
    protected $_component = 'BulkOperation';

    public function createBulkOperation($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $params = $this->getFilteredParams($request_data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\BulkOperationQL')->createBulkOperation($params);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function getBulkOperation($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $params = $this->getFilteredParams($request_data);

                if(isset($params['id'])) {
                    $response = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\BulkOperationQL')->getBulkOperation($params['id']);
                }
                else {
                    $response = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\BulkOperationQL')->getCurrentBulkOperation();
                }

                if($response['success'] && $response['data']['status'] === 'COMPLETED' && isset($params['save_file']) && $params['save_file']) {
                    $saved_file = $this->saveFile($response['data'], $shop, $params);
                    if($saved_file['status'] === true) {
                        $response['data']['saved_file_path'] = $saved_file['relative_path'];
                    }
                    else {
                        // $response['data']['saved_file_path'] = $saved_file['error'];
                    }
                }

                return $response;
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function cancelBulkOperation($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $params = $this->getFilteredParams($request_data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\BulkOperation\BulkOperationQL')->cancelBulkOpearion($params['id']);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function getBulkItem($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $params = $this->getFilteredParams($request_data);

                if(isset($params['next'])) {
                    $data['next'] = $params['next'];
                } else {
                    $data['limit'] = $params['limit'] ?? 250;
                }

                $filepath = BP . DS . $params['file_path'];

                $obj = new JSONLParser($filepath);
                $response =  $obj->getItems($data);

                if($response['success'] && !isset($response['cursors']) && isset($params['delete_file_at_last']) && $params['delete_file_at_last']) {
                    $this->deleteFile($filepath);
                }
                
                return $response;
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function getBulkItemCount($request_data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                $params = $this->getFilteredParams($request_data);

                $filepath = BP . DS . $params['file_path'];

                $obj = new JSONLParser($filepath);
                return $obj->getItemCount();
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage(),
                'trace' => $exception->getTraceAsString()
            ];
        }
    }

    public function saveFile($data, $shop, $params)
    {
        if(isset($params['file_name']) && strpos($params['file_name'], '.jsonl')) {
            $filename = $params['file_name'];
        }
        else {
            $filename = $this->getFileNameFromUrl($data['url']);
        }

        $relative_path = 'var' . DS . 'shopify' . DS . $shop['shop_url'];

        $path = BP . DS . $relative_path;

        if(!file_exists($path)) {
            $oldmask = umask(0);
            mkdir($path, 0777, true);
            umask($oldmask);
        }

        $filepath = $path . DS . $filename;

        $handle = fopen($filepath, 'w');

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL             => $data['url'],
            CURLOPT_FILE            => $handle,
            CURLOPT_FOLLOWLOCATION  => true,
            CURLOPT_FAILONERROR     => true, // HTTP code > 400 will throw curl error
        ]);
        $curl_resp = curl_exec($ch);

        if($curl_resp === false) 
        {
            $error = curl_error($ch);

            fclose($handle);
            curl_close($ch);

            return [
                'status' => false,
                'error'  => $error
            ];
        }
        else 
        {
            fclose($handle);
            curl_close($ch);

            return [
                'status'        => true,
                'relative_path' => $relative_path . DS . $filename,
                'absolute_path' => $filepath
            ];
        }
    }

    public function deleteFile($filepath)
    {
        unlink($filepath);
    }

    private function getFileNameFromUrl($url)
    {
        $parsedUrl = parse_url($url);

        parse_str($parsedUrl['query'], $parsedStr);

        $str = $parsedStr['response-content-disposition'];
        $start = strlen('attachment; filename="');
        $length = strpos($str, '";')-$start;
        $file_name = substr($str, $start, $length);
        
        return $file_name;
    }
}