<?php
namespace App\Shopifywebapi\Api\Billing;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class UsageCharge extends \App\Shopifywebapi\Api\Base
{
    protected $_component = 'UsageCharge';

    public function create($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                $data = $this->getFilteredParams($data);
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\UsageCharge'.$callType)->createUsageApplicationCharge($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }






}