<?php
namespace App\Shopifywebapi\Api\Billing;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Recurring extends \App\Shopifywebapi\Api\Base
{
    protected $_component = 'Recurring';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                // $default_params = ['_url', 'appId', 'shop_id'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\Recurring');
                // $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\Recurring'.$callType);
                return $object->getRecurringApplicationCharges($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function create($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                // $default_params = ['_url', 'appId', 'shop_id'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\Recurring'.$callType)->createRecurringApplicationCharge($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function delete($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\Recurring'.$callType)->cancelRecurringApplicationCharge($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function activate($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\Recurring')->activateRecurringApplicationCharge($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function update($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\Recurring')->updateRecurringApplicationCharge($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}