<?php
namespace App\Shopifywebapi\Api\Billing;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class OneTime extends \App\Shopifywebapi\Api\Base
{
    protected $_component = 'OneTime';

    public function get($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                // $default_params = ['_url', 'appId', 'shop_id', 'sAppId'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\OneTime');
                // $object = $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\OneTime'.$callType);
                return $object->getApplicationCharges($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function create($data)
    {
        try {
            $callType = $data['call_type'] ?? '';

            if($shop = $this->di->getRegistry()->getCurrentShop()) {

                // $default_params = ['_url', 'appId', 'shop_id', 'sAppId'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\OneTime'.$callType)->createApplicationCharge($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }

    public function activate($data)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                // $default_params = ['_url', 'appId', 'shop_id', 'sAppId'];
                // foreach ($default_params as $key) {
                //     unset($data[$key]);
                // }
                $data = $this->getFilteredParams($data);

                return $this->di->getObjectManager()->get('\App\Shopifywebapi\Components\Billing\OneTime')->activateApplicationCharge($data);
            }
            else
            {
                return [
                    'success'   => false,
                    'msg'       => 'shop_id not found'
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'msg' => $exception->getMessage()
            ];
        }
    }
}