<?php

namespace App\Shopifywebapi\Api\Billing;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Credit extends \App\Shopifywebapi\Api\Base
{
    protected $_component = 'Credit';

    public function createApplicationCredits($data)
    {
        try {
            $callType = $data['call_type'] ?? '';
            $shop = $this->di->getRegistry()->getCurrentShop();
            if (!$shop) {
                return [
                    'success' => false,
                    'message' => 'shop_id not found'
                ];
            }

            $data = $this->getFilteredParams($data);

            $creditComponent = $this->di
                ->getObjectManager()
                ->get('\App\Shopifywebapi\Components\Billing\Credit' . $callType);

            return $creditComponent->createApplicationCredits($data);
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}
