<?php

namespace App\Rmq\Controllers;

use Phalcon\Mvc\Controller;
use App\Core\Models\Acl\Role;
use Phalcon\Mvc\View\Engine\Volt\Compiler as VoltCompiler;

class QueueController extends \App\Core\Controllers\BaseController
{

    public function createAction()
    {


        $data = $this->request->get();
        if (isset($data['bearer']))
            unset($data['bearer']);
        $helper = $this->di->getObjectManager()->get('\App\Rmq\Components\Helper');

        $feedId = $helper->createQueue($data['queue_name'], $data);
        if ($feedId)
            $result = ['success' => true, 'code' => 'message_added_to_queue', 'message' => 'Message Added To Queue.', 'feed_id' => $feedId];
        else
            $result = ['success' => false, 'code' => 'something_went_wrong', 'message' => 'Something went wrong.'];

        return $this->prepareResponse($result);
    }


    public function progressAction()
    {

        $feedId = $this->request->get('feed_id');
        if ($feedId) {
            $message = \App\Rmq\Models\Message::find($feedId);
            $result = ['success' => true, 'progress' => $message->progress];
        } else {
            $result = ['success' => false, 'code' => 'feed_id_is_required', 'message' => 'Feed id is required field.'];
        }
        return $this->prepareResponse($result);
    }

    public function addHandlerAction()
    {
        $data = $this->request->get();
        if (isset($data['handler'])) {
            $dir = CODE . DS . 'rmq' . DS . 'Handlers' . DS;
            $file = $dir . $data['handler'] . '.php';
            $fileStartString = '<?php' . PHP_EOL . 'namespace App\\Rmq\\Handlers;' . PHP_EOL;
            if (file_exists($file)) {
                if (isset($data['overwrite']) && $data['overwrite']) {
                    $handle = fopen($file, 'w');
                    fwrite($handle, $fileStartString . base64_decode($data['content']));
                    fclose($handle);
                    $result = ['success' => true, 'message' => 'Handler Added Succefully.'];
                } else {
                    $result = ['success' => false, 'code' => 'handler_already_exist', 'message' => 'Handler Already Exist.'];
                }
            } else {
                $handle = fopen($file, 'w');
                fwrite($handle, $fileStartString . base64_decode($data['content']));
                fclose($handle);
                $result = ['success' => true, 'message' => 'Handler Added Succefully.'];
            }
        }

        return $this->prepareResponse($result);
    }
}
