<?php

namespace App\Rmq\Handlers;
class Qhandler extends \App\Core\Components\Base
{
    public function test($data) {
        sleep(1);
        echo 'working'.PHP_EOL;
        echo 'working2'.PHP_EOL;
        return true;
    }

    public function proxyFunction($data) {
        return true;
    }

    /** Internal **/
    public function consumerSyncProductData($data)
    {
        return $this->di->getObjectManager()->get('App\Shopify\Components\WebhookActions')->syncProductData($data['data']['realdata'], $data['data']['shop']);
    }

    public function consumerCreateProductData($data)
    {
        return $this->di->getObjectManager()->get('App\Shopify\Components\WebhookActions')->createProductData($data['data']['realdata'], $data['data']['shop']);
    }

    public function consumerDeleteProductData($data)
    {
        return $this->di->getObjectManager()->get('App\Shopify\Components\WebhookActions')->deleteProductData($data['data']['realdata'], $data['data']['shop']);
    }

    public function consumerSyncInventoryData($data)
    {
        return $this->di->getObjectManager()->get('App\Shopify\Components\WebhookActions')->updateInventoryOnOrder($data['data']['realdata'], $data['data']['shop']);
    }

    public function consumerUninstallApp($data)
    {
        return $this->di->getObjectManager()->get('App\Shopify\Components\WebhookActions')->uninstallApp($data['data']['realdata']);
    }

    public function uploadCustomLabel($data)
    {
        return $this->di->getObjectManager()->get('App\Engine\Models\ProductFeeds')->updateMetafieldForChunk($data['data']['product_chunk'], $data['data']['user_id'], $data['data']['shop'], $data['data']['path']);
    }

    public function consumerSyncFeedProducts($data)
    {
        $this->di->getLog()->logContent('Came in consumerSyncFeedProducts.', \Phalcon\Logger::INFO, 'syncProductData.log');
        switch ($data['data']['shopping_engine']) {
            case 'google':
                $userId = $data['data']['user_id'];
                $merchantId = $data['data']['merchant_id'];
                $chunkData = $data['data']['chunk_data'];
                $helper = $this->di->getObjectManager()->get('\App\Google\Components\Helper');
                $client = $helper->getGoogleClient($userId, $merchantId);
                $result = $helper->batchProcess($client, $chunkData);
                $this->di->getLog()->logContent('Response Data ' . $data['data']['shopping_engine'] . ' :' . PHP_EOL . json_encode($result), \Phalcon\Logger::INFO, 'syncProductData.log');
                if (count($result['errors'])) {
                    return false;
                }
                return true;
                break;
            case 'bing':
                $this->di->getLog()->logContent('Came in bing switch case.', \Phalcon\Logger::INFO, 'syncProductData.log');
                $shop = $data['data']['shop'];
                $chunkData = $data['data']['chunk_data'];
                $this->di->getLog()->logContent('Got shop and chunk data. Shop => ' . $shop, \Phalcon\Logger::INFO, 'syncProductData.log');
                $helper = $this->di->getObjectManager()->get('\App\Bing\Components\Helper');
                $helper->setDetails($shop);
                $this->di->getLog()->logContent('Got helper without any error.', \Phalcon\Logger::INFO, 'syncProductData.log');
                $chunkData = [
                  'entries' => $chunkData
                ];
                $result = $helper->batchProcess($chunkData);
                $this->di->getLog()->logContent('Response Data ' . $data['data']['shopping_engine'] . ' :' . PHP_EOL . json_encode($result), \Phalcon\Logger::INFO, 'syncProductData.log');
                if (count($result['errors'])) {
                    return false;
                }
                return true;
                break;
            default:
                return true;
        }
    }

    /** Internal End**/


    public function sendMail($data)
    {
        $msg = base64_decode($data['data']['content']);
        $this->di->getLog()->logContent('Senging queued mail', \Phalcon\Logger::CRITICAL, 'mail.log');
        $mailer = $this->di->getObjectManager()->get('mailer');
        if (isset($data['data']['bccs'])) {
            if ($mailer->sendmail($data['data']['email'], $data['data']['subject'], $msg, 0, true, $data['data']['bccs'])) {
                $this->di->getLog()->logContent('Mail Sent', \Phalcon\Logger::CRITICAL, 'mail.log');
                return true;
            } else {
                $this->di->getLog()->logContent('Mail Failed', \Phalcon\Logger::CRITICAL, 'mail.log');
                return false;
            }
        } else {
            if ($mailer->sendmail($data['data']['email'], $data['data']['subject'], $msg)) {
                $this->di->getLog()->logContent('Mail Sent', \Phalcon\Logger::CRITICAL, 'mail.log');
                return true;
            } else {
                $this->di->getLog()->logContent('Mail Failed', \Phalcon\Logger::CRITICAL, 'mail.log');
                return false;
            }
        }
    }

    public function getUrl($url = '')
    {
        return 'http://192.168.0.49/phalcon/public/' . $url;
    }

    public function uploadProduct($products)
    {
        $count = 1;
        try {
            foreach ($products['data']['products'] as $key => $value) {
                $handlerData = [
                    'type' => 'class',
                    'class_name' => 'Qhandler',
                    'method' => 'createProduct',
                    'queue_name' => 'product_queue',
                    'own_weight' => 100,
                    'weight_for_parent' => 100 / count($products['data']['products']),
                    'parent_id' => $products['message_id'],
                    'data' => [
                        'product' => $value,
                        'count' => $count,
                        'bearer' => $products['data']['bearer']
                    ]
                ];
                $helper = $this->di->getObjectManager()->get('\App\Rmq\Components\Helper');
                $helper->createQueue($handlerData['queue_name'], $handlerData);
            }
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public function createProduct($product)
    {
        $result = $this->di->getObjectManager()
                ->get('\App\Core\Components\Helper')
                ->curlRequest($this->getUrl('connector/product/createQueuedProducts'), $product['data'], false);
        return $result['responseCode'] == 200;
    }

    public function consumerSyncUserData($data)
    {
        return $this->di->getObjectManager()->get('\App\Hubspot\Components\Helper')->syncAllData($data['data']['userId']);
    }
}
