<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace App\Rmq\Components\MessageQueue;

interface QueueInterface
{
    /**
     * Get message from queue
     *
     * @return EnvelopeInterface
     */
    public function dequeue();

    /**
     * Acknowledge message delivery
     *
     * @param EnvelopeInterface $envelope
     * @return void
     */
    public function acknowledge(EnvelopeInterface $envelope);

    /**
     * Wait for messages and dispatch them
     *
     * @param callable|array $callback
     * @return void
     */
    public function subscribe();

    /**
     * Reject message
     *
     * @param EnvelopeInterface $envelope
     * @param bool $requeue
     * @param string $rejectionMessage
     * @return void
     */
    public function reject(EnvelopeInterface $envelope, $requeue = true, $rejectionMessage = null);

    /**
     * Push message to queue directly, without using exchange
     *
     * @param EnvelopeInterface $envelope
     * @return void
     */
    public function push($msg, $data = []);
}
