<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace App\Rmq\Components\MessageQueue;

use App\Rmq\Components\MessageQueue\Envelope;

/**
 * Factory class for @see \App\Rmq\Components\MessageQueue\Envelope
 */
class EnvelopeFactory
{


    /**
     * Create class instance with specified parameters
     *
     * @param array $data
     * @return \App\Rmq\Components\MessageQueue\Envelope
     */
    public function create(array $data = [])
    {

        return new Envelope($data['body'], $data['properties']);
    }
}
