<?php
namespace App\Rmq\Components;

use \Firebase\JWT\JWT;
use App\Rmq\Components\App\DeploymentConfig;
use App\Rmq\Components\MessageQueue\EnvelopeFactory;
use App\Rmq\Components\Config;
use App\Rmq\Components\Rqueue;

class Helper extends \App\Core\Components\Base
{
    //private $dir = BP.DS.'app'.DS.'etc'.DS.'security'.DS;

    /*
        $data = [
            'type' => 'url'
            'handler' => '',
            'class' => '',
            'method' => '',
            'success_url' => '',
            'data' => [],
        ]
    */

    /*
    STATUS
    2-> completed
    3-> added to failed queue
    4=> requeued
    5 => Failed
    */
    public function createQueue($queueName, $data)
    {
        $this->di->getMessageManager()->pushMessage($data);
    }
    public function pushMessage($data){
        try {

            if(isset($data['update_parent_progress'])){
                $this->updateProgress($data['parent_id'],$data['update_parent_progress']);
                return 0;
            }
            $deploymentConfig = new DeploymentConfig();
            $config = new Config($deploymentConfig);
            $envelopeFactory = new EnvelopeFactory();
            $queueName = $data['queue_name'];
            if(!isset($data['handle_added']) && $this->getDi()->getConfig()->get('app_code')){
                $queueName = $data['queue_name'] = $this->getDi()->getConfig()->get('app_code').'_'.$data['queue_name'];
                $data['handle_added'] = 1;

            }


            if (isset($data['message_id'])) {
            } else {
                $message = new \App\Rmq\Models\Message;
                $message->save(['queue_name'=>$data['queue_name'],
                    'is_child'=>isset($data['parent_id'])?1:0,
                    'parent_id'=>$data['parent_id']??0,

                ]);
                $data['message_id'] = $message->id;
            }

            //print_r($message->getMessages());die;
            $data['own_weight'] = $data['own_weight']??100;
            if (isset($data['parent_id'])) {
                $data['is_child'] = 1;
                $data['weight_for_parent'] = $data['weight_for_parent']??100;
            } else {
                $data['is_child'] = 0;
            }

            $queue = new Rqueue($config, $envelopeFactory, $queueName, $this->di);
            $queue->push(json_encode($data));
            $logger = $this->di->getLog();

            /*if($url = $this->getDi()->getConfig()->get('queue_handler_url')){

                $response = $this->callCurl($url,['queue'=>$queueName,'action'=>'add','path'=>BP.'/app/cli'],false);
                $logger->logContent(print_r($response,true), \Phalcon\Logger::DEBUG);
            }*/
            return $data['message_id'];
        } catch (\Exception $e) {
            $logger = $this->di->getLog();
            $logger->logContent($e->getMessage().PHP_EOL.$e->getTraceAsString());
            return false;
        }
    }

    public function updateProgress($id, $points)
    {

        $message = \App\Rmq\Models\Message::findFirst($id);
        if($message){
            $points = ($message->progress+$points);

            $message->save(['progress'=> $points < 100 ? $points : 100]);
        }

    }

    public function processMsg($msgArray)
    {
        if(isset($msgArray['message_reference_id'])){

            $obj = $this->getDi()->getObjectManager()->get($msgArray['class_name']);
            $method = $msgArray['method'];
            $msgArray = $obj->$method( $msgArray['message_reference_id']);
            if(!$msgArray){
                return true;
            }
        }
        $msgArray['type'] = $msgArray['type']??'default';
        $logger = $this->di->getLog();
        $queueName = $msgArray['queue_name'];
        if ($msgArray['type']=='url') {
            $response = $this->callCurl($msgArray['url'], $msgArray['data'], false);
            $file = 'queue/process.log';
            $logger->logContent('responseCode: '.$response['responseCode'], \Phalcon\Logger::DEBUG, $file);
            if ($response['responseCode']==200) {
                return true;
            } elseif ($response['responseCode']==503) {
                $data = ['message'=>$msgArray,'queue_name'=>$queueName];
                $this->createQueue('process_maintenance', $data);
                $logger->logContent('Source site is under maintenance.pushing data in maintenance queue', \Phalcon\Logger::DEBUG, $file);
                return true;
            }
            $logger->logContent($queueName.':'.print_r($msgArray, true), \Phalcon\Logger::DEBUG, $file);

            $logger->logContent('Url:'.$msgArray['url'].PHP_EOL.print_r($response, true), \Phalcon\Logger::DEBUG, $file);
            return false;
        } elseif ($msgArray['type']=='full_class') {
            if (isset($msgArray['class_name'])) {
                $obj = $this->getDi()->getObjectManager()->get($msgArray['class_name']);
                $method = $msgArray['method'];

                $start_time = microtime(true);
                $response = $obj->$method($msgArray);

                $end_time = microtime(true);
                $execution_time = ($end_time - $start_time);
                if ($execution_time > 4){
                    $logger->logContent("\tend function  {$method}  executed in :".$execution_time.PHP_EOL, \Phalcon\Logger::DEBUG, "queue-processing/{$queueName}.log");
                }
                return $response;
            } else {
                $logger->logContent(print_r($msgArray, true), \Phalcon\Logger::DEBUG, 'queue_failed.log');
                /* tdo if class not found */
                return true;
            }
        } elseif ($msgArray['type']=='class') {
            if (isset($msgArray['class_name'])) {
                $obj = $this->getDi()->getObjectManager()->get('App\\Rmq\\Handlers\\'.$msgArray['class_name']);

                $method = $msgArray['method'];
                $response = $obj->$method($msgArray);
                return $response;
            } else {
                $logger->logContent(print_r($msgArray, true), \Phalcon\Logger::DEBUG, 'queue_failed.log');
                /* tdo if class not found */
                return true;
            }
        } else {
            $obj = $this->getDi()->getObjectManager()->get('App\\Rmq\\Handlers\\Default1');
            if (isset($msgArray['method'])) {
                $method = $msgArray['method'];
                $response = $this->$method($msgArray);
                return $response;
            } else {
                $logger->logContent(print_r($msgArray, true), \Phalcon\Logger::DEBUG, 'queue_failed.log');
                return true;
                /*todo handle without method message*/
            }
        }
    }


    public function callCurl($url, $data, $json = true, $returnTransfer = true)
    {

        $data_string = json_encode($data);
        // Initialize cURL
        $ch = curl_init();
        // Set URL on which you want to post the Form and/or data
        curl_setopt($ch, CURLOPT_URL, $url);
        // Data+Files to be posted
        if ($json) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($data_string)));
        } else {
            curl_setopt($ch, CURLOPT_POST, 1);
            // Data+Files to be posted

            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
        // Pass TRUE or 1 if you want to wait for and catch the response against the request made
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, $returnTransfer);
        curl_setopt($ch, CURLOPT_HEADER, false);


        // For Debug mode; shows up any error encountered during the operation
        curl_setopt($ch, CURLOPT_VERBOSE, 1);


        // Execute the request
        $response = curl_exec($ch);

        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if (curl_errno($ch)) {
            return ['responseCode'=>$httpcode,'errorMsg'=>curl_error($ch)];
        }

        curl_close($ch);
        if ($httpcode!=200) {
            // preg_match_all('/<div class=\"header(.*?)\">(.*?)<\/div>/s',$response,$output,PREG_SET_ORDER);
            //preg_match_all('/<div class="header">(.*?)</div>/s', $response, $output);

            return ['responseCode'=>$httpcode,'errorMsg'=>$response];
            //var_dump($output);
        } else {
            return ['responseCode'=>$httpcode,'response'=>$response];
        }
        // Just for debug: to see response
    }
}
