<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

use App\Michaelswebapi\Components\Core\Common As CoreCommon;
return [
    'restapi' => [
        'v1'=> [
            'GET' => [
                'routes' => [
                        
                   
                    /* Listing Start */
                    CoreCommon::REST_URL_PREFIX . 'listing/taxonomy/get-taxonomy-attributes'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/taxonomy/get-taxonomy-attributes',
                        'method' => 'getTaxonomyAttributes',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/taxonomy/get-taxonomy-attributes',
                        'component'=> 'Taxonomy',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/taxonomy'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/taxonomy',
                        'method' => 'getTaxonomy',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/taxonomy',
                        'component'=> 'Taxonomy',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/query'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/query',
                        'method' => 'getQueryListing',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/query',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/all-listings'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/all-listings',
                        'method' => 'getAllListing',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/all-listings',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/sku-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/sku-number',
                        'method' => 'getListingBySkuNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/sku-number',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/inventory/primary-sku-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/primary-sku-number',
                        'method' => 'getInventoriesByPrimarySkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/primary-sku-number',
                        'component'=> 'Listing',
                        'required' => ['primarySkuNumber']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/price/primary-sku-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/price/primary-sku-number',
                        'method' => 'getPriceByPrimarySkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/price/primary-sku-number',
                        'component'=> 'Listing',
                        'required' => ['primarySkuNumber']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/get-upload-listing-tasks'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/get-upload-listing-tasks',
                        'method' => 'getUploadListingTasks',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/get-upload-listing-tasks',
                        'component'=> 'Listing',
                    ],

                    /* Listing End */

                    /* Order Start */
                    CoreCommon::REST_URL_PREFIX . 'order/query'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/query',
                        'method' => 'getQueryOrder',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/query',
                        'component'=> 'Order',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'order/order-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/order-number',
                        'method' => 'getOrderByOrderNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/order-number',
                        'component'=> 'Order',
                    ],

                    /* Order End */

                    /* Returns Start */
                    CoreCommon::REST_URL_PREFIX . 'order/returns/return-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/returns/return-number',
                        'method' => 'getReturnByReturnNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/returns/return-number',
                        'component'=> 'Returns',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'order/returns/order-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/returns/order-number',
                        'method' => 'getReturnByOrderNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/returns/order-number',
                        'component'=> 'Returns',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'order/returns/list'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/returns/list',
                        'method' => 'getQueryReturns',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/returns/list',
                        'component'=> 'Returns',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'migration'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'migration',
                        'method' => 'get',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'migration',
                        'component'=> 'Migration',
                    ],

                    /* Returns End */
                ],
            ],
            'POST' => [
                'routes' => [
                    /* Add shop via API start */
                    CoreCommon::REST_URL_PREFIX . 'authenticate' => [
                        'url' => CoreCommon::REST_URL_PREFIX . 'authenticate',
                        'method' => 'addMichaelsInformation',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'authenticate',
                        'component'=> 'Authenticate',
                        'required' => [
                            CoreCommon::MICHAELS_EMAIL_FIELD,
                            CoreCommon::MICHAELS_API_KEY_FIELD,
                            CoreCommon::MICHAELS_DOMAIN_FIELD
                        ]
                    ],

                    /* Add shop via API end */

                    /* Listing Start */
                    CoreCommon::REST_URL_PREFIX . 'listing'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing',
                        'method' => 'createListing',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/activate'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/activate',
                        'method' => 'activateListing',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/activate',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/deactivate'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/deactivate',
                        'method' => 'deactivateListing',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/deactivate',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/update-status'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/update-status',
                        'method' => 'activateDeactivateSkus',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/update-status',
                        'component'=> 'Listing',
                        'required' => ['data']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/inventory/update-inventory'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/update-inventory',
                        'method' => 'updateInventoryBySkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/update-inventory',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/price/publish'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/price/publish',
                        'method' => 'updatePriceBySkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/price/publish',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/price/publish-by-seller-sku-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/price/publish-by-seller-sku-number',
                        'method' => 'updatePriceBySellerSkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/price/publish-by-seller-sku-number',
                        'component'=> 'Listing',
                        'required' => ['data']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/price/sku-number/batch-get'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/price/sku-number/batch-get',
                        'method' => 'getSkuPriceInBatchBySkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/price/sku-number/batch-get',
                        'component'=> 'Listing',
                        'required' => ['skuNumbers']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/create-update-listing-by-excel'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/create-update-listing-by-excel',
                        'method' => 'createUpdateListingByExcelTemplate',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/create-update-listing-by-excel',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/asynchronous-create-update-listing-by-excel'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/asynchronous-create-update-listing-by-excel',
                        'method' => 'asynchronousCreateUpdateListingByExcelTemplate',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/asynchronous-create-update-listing-by-excel',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/query-by-export-excel'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/query-by-export-excel',
                        'method' => 'exportExcel',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/query-by-export-excel',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/inventory/seller-sku-number/batch-get'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/seller-sku-number/batch-get',
                        'method' => 'getInventoryInBatchBySellerSkuNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/seller-sku-number/batch-get',
                        'component'=> 'Listing',
                        'required' => ['sellerSkuNumbers']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/inventory/update-inventory-by-seller-sku-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/update-inventory-by-seller-sku-number',
                        'method' => 'updateInventoryBySellerSkuNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/update-inventory-by-seller-sku-number',
                        'component'=> 'Listing',
                        'required' => ['data']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/inventory/sku-number/batch-get'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/sku-number/batch-get',
                        'method' => 'getInventoryInBatchBySkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/inventory/sku-number/batch-get',
                        'component'=> 'Listing',
                        'required' => ['skuNumbers']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/batch-get'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/batch-get',
                        'method' => 'getListingInBatchBySkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/batch-get',
                        'component'=> 'Listing',
                        'required' => ['sku_numbers']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/seller-sku-number/batch-get'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/seller-sku-number/batch-get',
                        'method' => 'getListingInBatchBySellerSkuNumbers',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/seller-sku-number/batch-get',
                        'component'=> 'Listing',
                        'required' => ['seller_sku_numbers']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/price/seller-sku-number/batch-get'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/price/seller-sku-number/batch-get',
                        'method' => 'getPriceInBatchBySellerSkuNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/price/seller-sku-number/batch-get',
                        'component'=> 'Listing',
                        'required' => ['sellerSkuNumbers']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/media'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/media',
                        'method' => 'createMediaUrl',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/media',
                        'component'=> 'Listing',
                        'required' => ['file_path']
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/cancel-upload-tasks'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/cancel-upload-tasks',
                        'method' => 'cancelUploadTasks',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/cancel-upload-tasks',
                        'component'=> 'Listing',
                    ],

                    /* Listing End */

                    /* Order Start */
                    CoreCommon::REST_URL_PREFIX . 'order/confirm'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/confirm',
                        'method' => 'confirmAnOrder',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/confirm',
                        'component'=> 'Order',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'order/shipped'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/shipped',
                        'method' => 'addAnShipmentToOrderItems',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/shipped',
                        'component'=> 'Order',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'order/cancel-order'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/cancel-order',
                        'method' => 'cancelOrder',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/cancel-order',
                        'component'=> 'Order',
                    ],

                    /* Order End */

                    /* Returns Start */
                    CoreCommon::REST_URL_PREFIX . 'order/returns/process-refund'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'order/returns/process-refund',
                        'method' => 'processRefund',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'order/returns/process-refund',
                        'component'=> 'Returns',
                    ],

                    /* Returns End */
                ]
            ],
            'PUT' => [
                'routes' => [
                    /* Listing Start */
                    CoreCommon::REST_URL_PREFIX . 'listing/sku-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/sku-number',
                        'method' => 'updateListing',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/sku-number',
                        'component'=> 'Listing',
                    ],

                    CoreCommon::REST_URL_PREFIX . 'listing/seller-sku/seller-sku-number'=> [
                        'url' => CoreCommon::REST_URL_PREFIX . 'listing/seller-sku/seller-sku-number',
                        'method' => 'updateListingBySellerSkuNumber',
                        'resource' => CoreCommon::REST_URL_PREFIX . 'listing/seller-sku/seller-sku-number',
                        'component'=> 'Listing',
                        'required' => ['sellerSkuNumber']
                    ],

                    /* Listing End */
                ]
                ],
                'DELETE' => [
                    'routes' => [
                        CoreCommon::REST_URL_PREFIX . 'listing/delete-listing-by-sku-number'=> [
                            'url' => CoreCommon::REST_URL_PREFIX . 'listing/delete-listing-by-sku-number',
                            'method' => 'deleteListingBySkuNumber',
                            'resource' => CoreCommon::REST_URL_PREFIX . 'listing/delete-listing-by-sku-number',
                            'component'=> 'Listing'
                        ],
                    ]
                ]
        ],
    ],
];