<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Controllers;

use App\Michaelswebapi\Components\Authenticate\Authenticate;

class TestController extends \App\Core\Controllers\BaseController
{
    public function insertAppsShopAction()
    {
        $shop_data = array(["_id" => 218, "shop_url" => "custom-michaels.myshopify.com", "token" => "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", "app_key" => "c06c50266d046959beda6eda68f4345c", "app_secret" => "366be3284e53f09d19367e0208e9aa96", "group_code" => "default", "app_code" => "default", "is_custom" => true, "apps" => ["default" => ["app_id" => 7, "token" => "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", "sub_app_id" => 4]], "sub_apps" => [4], "app_id" => 7], ["_id" => 446, "shop_url" => "ironman-cedstore.myshopify.com", "token" => "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", "app_key" => "0db9c3bef99d1904c2d1dbfe53d30c11", "app_secret" => "cdd504f2316a70bd249b32b1b0943ddd", "group_code" => "default", "app_code" => "default", "is_custom" => true, "apps" => ["default" => ["app_id" => 7, "token" => "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", "sub_app_id" => 4]], "sub_apps" => [4], "app_id" => 7]);

        $query = '{
            app {
                id
                }
            }
            ';
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');

        foreach ($shop_data as $shop) {
            $url = 'https://' . $shop['shop_url'] . '/admin/api/2021-07/graphql.json';

            $headers = [
                'Content-Type' => 'application/graphql',
                'X-Shopify-Access-Token' => $shop['token']
            ];
            $response = $this->di->getObjectManager()->get('App\Core\Components\Guzzle')
                ->call($url, $headers, $query, 'POST', 'body');
            if (isset($response['errors'])) {
                $this->di->getLog()->logContent('failed -> ' . json_encode($shop, 128), 'info', 'failed_app_shop.log');
                return $this->prepareResponse(['success' => false, 'data' => $response['errors']]);
            }
            $id = explode('App/', $response['data']['app']['id'])[1];
            $cif_app_id = (string)$mongo->getCounter('apps_id');
            $format_shop[] = [
                "_id" => (string)$shop['_id'],
                "apps" => [
                    [
                        "shop_url" => $shop['shop_url'],
                        "client_id" => $shop['app_key'],
                        "client_secret" => $shop['app_secret'],
                        "shopify_app_id" => $id,
                        "is_private" => true,
                        "token" => $shop['token'],
                        "cif_app_id" => $cif_app_id,
                        "app_code" => "shopify_michael",
                        "app_id" => "1",
                        "sub_app_id" => "1",
                        "active" => true
                    ]
                ],
                "group_code" => "shopify_michael",
                "id" => (string)$shop['_id'],
                "shop_url" => $shop['shop_url'],
                "sub_apps" => [
                    "1"
                ]
            ];
            $format_app[] = [
                [  "_id"=> $cif_app_id,  "id"=> $cif_app_id,  "is_visible"=> false,  "shop_id"=> (string)$shop['_id']]
            ];
            $format_cedcommerce_app_shops[] = [
                [ "remote_shop_id"=> (string)$shop['_id'],  "sAppId"=> "1",  "ced_subuser_id"=> "1",  "ced_sAppId"=> "3"]
            ];
        }
        return $this->prepareResponse(['success' => true,'apps_shop'=> $format_shop,'apps' => $format_app,'cedcommerce_apps_shop' => $format_cedcommerce_app_shops]);
    }

    public function testAction() {
        die('hello');
    }
}
