<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Controllers;

use App\Michaelswebapi\Components\Authenticate\Authenticate;

class MigrationController extends \App\Core\Controllers\BaseController
{
    public $michael_remote;
    public $Dbconfig;
    public $old_michael;

    public function init()
    {
        $this->Dbconfig = $this->di->getConfig()->get('databases')->toArray();
        $this->old_michael = $this->Dbconfig['old_michael'];
        $this->michael_remote = $this->setDbSource($this->old_michael);
    }


    public function setDbSource($database, $dbName = false)
    {
        $dsn =  $database['host'];
        $mongo = new \MongoDB\Client($dsn, array("username" => $database['username'], "password" => $database['password']));
        $mongo =  $mongo->selectDatabase($database['dbname']);

        return $mongo;
    }

    public function appsShopAction()
    {
        $this->init();
        $shop = $this->michael_remote->selectCollection("apps_shop")->findOne(['shop_url' => "custom-michaels.myshopify.com"]);
        $shop = json_decode(json_encode($shop), true);
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');

        $query = '{
            app {
                id
                }
            }
            ';

        $url = 'https://' . $shop['shop_url'] . '/admin/api/2021-07/graphql.json';

        $headers = [
            'Content-Type' => 'application/graphql',
            'X-Shopify-Access-Token' => $shop['token']
        ];
        $response = $this->di->getObjectManager()->get('App\Core\Components\Guzzle')
            ->call($url, $headers, $query, 'POST', 'body');

        if (isset($response['errors'])) {
            $this->di->getLog()->logContent('failed -> ' . json_encode($shop, 128), 'info', 'failed_app_shop.log');
            return $this->prepareResponse(['success' => false, 'data' => $shop['errors']]);
        }
        $id = explode('App/', $response['data']['app']['id'])[1];
        // $cif_app_id = (string)$mongo->getCounter('apps_id');
        $cif_app_id = "4";
        $format_shop = [
            "_id" => (string)$shop['_id'],
            "apps" => [
                [
                    "shop_url" => $shop['shop_url'],
                    "client_id" => $shop['app_key'],
                    "client_secret" => $shop['app_secret'],
                    "shopify_app_id" => $id,
                    "is_private" => true,
                    "token" => $shop['token'],
                    "cif_app_id" => $cif_app_id,
                    "app_code" => "shopify_michael",
                    "app_id" => "1",
                    "sub_app_id" => "1",
                    "active" => true
                ]
            ],
            "group_code" => "shopify_michael",
            "id" => (string)$shop['_id'],
            "shop_url" => $shop['shop_url'],
            "sub_apps" => [
                "1"
            ]
        ];


        $format_app = ["_id" => $cif_app_id,  "id" => $cif_app_id,  "is_visible" => false,  "shop_id" => (string)$shop['_id']];
        $format_cedcommerce_app_shops = ["remote_shop_id" => (string)$shop['_id'],  "sAppId" => "1",  "ced_subuser_id" => "1",  "ced_sAppId" => "3"];
        $appsShopCollection = $mongo->getCollectionForTable("apps_shop");
        $insert = $appsShopCollection->insertOne($format_shop);
        $appsCollection = $mongo->getCollectionForTable("apps");
        $insert1 = $appsCollection->insertOne($format_app);
        $cedcommerceAppsShopCollection = $mongo->getCollectionForTable("cedcommerce_app_shops");
        $insert1 = $cedcommerceAppsShopCollection->insertOne($format_cedcommerce_app_shops);
        return $this->prepareResponse(['success' => true, 'format_shop' => $format_shop, 'format_app' => $format_app, 'format_cedcommerce_app_shops' => $format_cedcommerce_app_shops]);
    }
}
