<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Controllers;

use App\Michaelswebapi\Components\Authenticate\Authenticate;

class AuthController extends \App\Core\Controllers\BaseController
{
    const COMMENCE_AUTH_URL = 'apiconnect/request/commenceAuth';

    public function installAction()
    {
        $this->view->setViewsDir(CODE . '/michaelswebapi/views/');
        $this->view->setVars([
            'query_params' => [
                'sAppId' => $this->getDI()->getRequest()->get('sAppId'),
                'state' => $this->getDI()->getRequest()->get('state'),
                'domain' => $this->getDI()->getRequest()->get('domain'),
                'mode' => $this->getDI()->getRequest()->get('mode'),
            ],
            'url' => $this->di->getConfig()->get('backend_base_url') . self::COMMENCE_AUTH_URL,
            'email' => $this->getDI()->getRequest()->get('email'),

        ]);
        $this->view->pick('auth/install');
    }

    //for the redirect the page
    public function verifyAction()
    {
        // return $this->prepareResponse([
        //     "success" => false,
        //     "message" => "Testing.",
        // ]);

        $contentType = $this->request->getHeader('Content-Type');
        if (strpos($contentType, 'application/json') !== false) {
            $postData = $this->request->getJsonRawBody(true);
        } else {
            $postData = $this->di->getRequest()->get();
        }

        $email = isset($postData['email']) ? trim(strtolower($postData['email'])) : '';
        $apiKey = isset($postData['apikey']) ? trim($postData['apikey']) : '';
        $domain = isset($postData['domain']) ? trim(strtolower($postData['domain'])) : '';
        $emptyIndex = [];
        if (!$email) {
            $emptyIndex[] = "Email";
        }
        if (!$apiKey) {
            $emptyIndex[] = "Api Key";
        }
        if (!empty($emptyIndex)) {
            return $this->prepareResponse([
                "success" => false,
                "message" => "Please Enter " . implode(' & ', $emptyIndex) . '.',
            ]);
        }
        if (!$domain) {
            return $this->prepareResponse([
                "success" => false,
                "message" => "Unable to find domain.",
            ]);
        }
        $authenticateClass = $this->di->getObjectManager()->get(Authenticate::class);
        if (!$authenticateClass->checkEmail($email)) {
            return $this->prepareResponse([
                "success" => false,
                "message" => "Please Enter Valid Email." . implode(', ', $emptyIndex),
            ]);
        }
        $response = $authenticateClass->testApiKey($apiKey, ['mode' => $postData['mode']]);
        
        // $response['code'] = 200;
        // return $this->prepareResponse([
        //     "success" => false,
        //     "message" => json_encode($postData)." ----- ".json_encode($response),
        // ]);
        if (isset($response['code'])) {
            if ($response['code'] == 200) {

                return $this->prepareResponse([
                    "success" => true,
                    "message" => "Welcome User",
                ]);
            }
            return $this->prepareResponse([
                "success" => false,
                "message" => $response['message'],
            ]);
        }
        return $this->prepareResponse([
            "success" => false,
            "message" => "Sorry You are not authorized",
        ]);
    }
}
