<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Components\Route;

class Handler extends \App\Michaelswebapi\Components\Core\Common
{
    public function requestRedirectAuthUrl($postData)
    {
        $appId = $this->getDi()->getRequest()->get("sAppId");
        $this->di->getLog()->logContent('appId -> '.json_encode($appId),'info','onboard_remote.log');
        $email = $this->getDi()->getRequest()->get("email");
        $domain = $this->getDi()->getRequest()->get("domain");
        $base_url = $this->di->getConfig()->get('backend_base_url');
        $mode =  $this->getDi()->getRequest()->get('mode');

        $state = $this->getStateToken();
        
        $redirectUri = $this->di->getConfig()->get('backend_base_url')  ."apiconnect/request/commenceAuth";
        
        $auth_url = $base_url . 'michaelswebapi/auth/install?sAppId=' . $appId .'&email=' . $email .'&state=' . $state .'&domain=' . $domain . "&redirect_url=" . $redirectUri;
        return [
            "success" => true,
            "authUrl" => $auth_url
        ];
    }
    
    public function processAuth()
    {
        $email = trim(strtolower($this->di->getRequest()->get('email')));
        $domain = trim(strtolower($this->di->getRequest()->get('domain')));
        $apikey = trim($this->di->getRequest()->get('api-key'));
        
        if ($email && $apikey) {
            $response = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                [
                    self::MICHAELS_API_KEY_FIELD => $apikey,
                    self::MICHAELS_EMAIL_FIELD => $email,
                    self::MICHAELS_DOMAIN_FIELD => $domain,
                    'is_private' => true
                ],
                [
                    self::MICHAELS_DOMAIN_FIELD,
                    'group_code']

            );
            $this->di->getLog()->logContent('responseShop-> '.json_encode($response,128),'info','shop.log');
            
            return $response;
        }
    }
}
