<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Components;

use App\Michaelswebapi\Components\Core\Common As CoreCommon;

/**
 * Class Order
 * @package App\Michaelswebapi\Components
 */
class Returns extends CoreCommon
{
    /**
     * @param $data
     * @return mixed
     */
    public function getReturnByReturnNumber($data) {
        return $this->rest(
            'GET',
            str_replace('{returnNumber}', $data['returnNumber'], self::GET_RETURN_BY_REQUEST_NUMBER_END_POINT),
            [],
            []
        );
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getReturnByOrderNumber($data) {
        return $this->rest(
            'GET',
            str_replace('{orderNumber}', $data['orderNumber'], self::GET_RETURN_BY_ORDER_NUMBER_END_POINT),
            [],
            []
        );
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getQueryReturns($data) {
        return $this->rest(
            'GET',
            self::GET_QUERY_RETURN_END_POINT,
            $data,
            []
        );
    }

    /**
     * @param $data
     * @return mixed
     */
    public function processRefund($data) {
        return $this->rest(
            'POST',
            self::PROCESS_REFUND_END_POINT,
            $data,
            []
        );
    }

}