<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Components;

use App\Michaelswebapi\Components\Core\Common As CoreCommon;

/**
 * Class Order
 * @package App\Michaelswebapi\Components
 */
class Order extends CoreCommon
{
    /**
     * @param $data
     * @return mixed
     */
    public function getQueryOrder($data) {
        $res = $this->rest(
            'GET',
            self::GET_QUERY_ORDERS_END_POINT,
            $data,
            []
        );
        return $res;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getOrderByOrderNumber($data) {
        return $this->rest(
            'GET',
            str_replace('{orderNumber}', $data['orderNumber'], self::GET_ORDER_BY_ORDER_NUMBER_END_POINT),
            [],
            []
        );
    }

    /**
     * @param $data
     * @return mixed
     */
    public function confirmAnOrder($data) {
        return $this->rest(
            'POST',
            self::CONFIRM_AN_ORDER_END_POINT,
            $data,
            []
        );
    }

    /**
     * @param $data
     * @return mixed
     */
    public function addAnShipmentToOrderItems($data) {
        return $this->rest(
            'POST',
            self::ADD_AN_SHIPMENT_TO_ORDER_ITEMS_END_POINT,
            $data,
            []
        );
    }

    /**
     * @param $data
     * @return mixed
     */
    public function cancelOrder($data) {
        return $this->rest(
            'POST',
            self::CANCEL_ORDER_END_POINT,
            $data,
            []
        );
    }

}