<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Components\Core;

use Exception;
use GuzzleHttp\Client;

class Common extends \App\Apiconnect\Components\Authenticate\Common
{
    const REST_URL_PREFIX = 'michaels/';

    const MICHAELS_API_KEY_FIELD = 'michaels_api_key';

    const MICHAELS_EMAIL_FIELD = 'email';

    const MICHAELS_DOMAIN_FIELD = 'domain';

    const SANDBOX_ORDER_API = 'sandbox-order-api';

    const SANDBOX_API_URL_PREFIX_CONFIG_INDEX = 'sandbox-api-url-prefix';

    const PRODUCTION_API_URL_PREFIX_CONFIG_INDEX = 'production-api-url-prefix';

    const CREATE_UPDATE_EXCEL_SAMPLE_FILE_NAME = 'Create_Update_Listing.xlsx';

    const ACTIVE_WORKSHEET_NAME = 'Template';

    const EXCEL_HEADER_ROW = 5;

    const MAX_TAG_COUNT = 10;

    const MAX_IMAGE_COUNT = 6;

    const MAX_VARIANT_VALUE_COUNT = 3;

    const MAX_ALLOWED_PRODUCT_COUNT_FOR_EXCEL_IMPORT = 1000;

    const BATCH_SIZE = 100;

    const TAXONOMY_ATTRIBUTE_COLUMN_STARTS_FROM = 'BJ';

    const EXPORT_EXCEL_TAXONOMY_ATTRIBUTE_COLUMN_STARTS_FROM = 'BO';

    const TAG_PREFIX_FOR_EXCEL = 'tag_';

    const VARIANT_PREFIX_FOR_EXCEL = 'variant_value_';

    const IMAGE_URL_PREFIX_FOR_EXCEL = 'image_url_';

    const WRITE_EXCEL_PREFIX = 'excel_';

    const MICHAELS_EXPORT_DIRECTORY_NAME = 'michaels_excel_export';

    const MICHAELS_IMPORT_DIRECTORY_NAME = 'michaels_excel_import';

    const SHOP_NOT_FOUND_ERROR_MESSAGE = 'Shop not found.';

    const API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE = 'API Key does not exist.';

    const SELLER_SKU_NUMBERS_SHOULD_BE_AN_ARRAY_ERROR_MESSAGE = '\'sellerSkuNumbers\' should be an array.';

    const DATA_SHOULD_BE_AN_ARRAY_ERROR_MESSAGE = '\'data\' should be an array.';

    /**
     * End Point's Suffix start
     */
    const AUTHENTICATION_TEST_AUTH_END_POINT = 'listing/authentication/test-auth';

    /* Listing End Points */

    const GET_TAXONOMY_END_POINT = 'listing/taxonomy';

    const CANCEL_BULK_TASK_END_POINT = 'listing/cancel-upload-tasks';

    const GET_ALL_LISTINGS = 'listing/all-listings';

    const GET_TAXONOMY_ATTRIBUTE_END_POINT = 'listing/taxonomy/get-taxonomy-attributes';

    const DOWNLOAD_TAXONOMY_EXCEL_TEMPLATE_END_POINT = 'listing/download-excel-template';

    const CREATE_UPDATE_LISTING_BY_EXCEL_TEMPLATE_END_POINT = 'listing/upload-excel';

    const CREATE_LISTING_END_POINT = 'listing';

    const UPDATE_LISTING_END_POINT = 'listing/{primarySkuNumber}';

    const UPDATE_A_LISTING_BY_SELLER_SKU_NUMBER_END_POINT = 'listing/seller-sku/{sellerSkuNumber}';

    const UPDATE_SKU_PRICE_BY_SELLER_SKU_NUMBERS_END_POINT = 'listing/price/publish-by-seller-sku-number';

    const UPDATE_INVENTORY_BY_SELLER_SKU_NUMBERS_END_POINT = 'listing/inventory/update-inventory-by-seller-sku-number';

    const GET_LISTING_BY_SKU_NUMBER_END_POINT = 'listing/{skuNumber}';

    const GET_LISTING_IN_BATCH_BY_SKU_NUMBERS_END_POINT = 'listing/batch-get';

    const EXPORT_EXCEL_END_POINT = 'listing/export-excel';

    const GET_QUERY_LISTING_END_POINT = 'listing/query';

    const GET_LISTING_IN_BATCH_BY_SELLER_SKU_NUMBERS_END_POINT = 'listing/seller-sku-number/batch-get';

    const ACTIVATE_DEACTIVATE_SKUS_END_POINT = 'listing/update-status';

    const ASYNCHRONOUS_CREATE_UPDATE_LISTING_BY_EXCEL_TEMPLATE_END_POINT = 'listing/upload-excel-asyn';

    const GET_UPLOAD_LISTING_TASKS_END_POINT = 'listing/get-upload-listing-tasks';

    const GET_SKU_INVENTORIES_BY_PRIMARY_SKU_NUMBER_END_POINT = 'listing/inventory/{primarySkuNumber}';

    const GET_INVENTORIES_IN_BATCH_BY_SKU_NUMBERS_END_POINT = 'listing/inventory/sku-number/batch-get';

    const GET_INVENTORY_IN_BATCH_BY_SELLER_SKU_NUMBERS_END_POINT = 'listing/inventory/seller-sku-number/batch-get';

    const UPDATE_INVENTORY_BY_SKU_NUMBERS_END_POINT = 'listing/inventory/update-inventory';

    const GET_SKU_PRICE_BY_PRIMARY_SKU_NUMBER_END_POINT = 'listing/price/{primarySkuNumber}';

    const GET_SKU_PRICE_IN_BATCH_BY_SKU_NUMBERS_END_POINT = 'listing/price/sku-number/batch-get';

    const GET_PRICE_IN_BATCH_BY_SELLER_SKU_NUMBERS_END_POINT = 'listing/price/seller-sku-number/batch-get';

    const UPDATE_PRICE_BY_SKU_NUMBERS_END_POINT = 'listing/price/publish';

    const CREATE_MEDIA_URL_END_POINT = 'listing/media';

    const ACTIVATE_LISTING_END_POINT = 'listing/activate';

    const DEACTIVATE_LISTING_END_POINT = 'listing/deactivate';

    /* Listing End Points */

    /* Orders End Points */

    const GET_QUERY_ORDERS_END_POINT = 'order/query';

    const GET_ORDER_BY_ORDER_NUMBER_END_POINT = 'order/{orderNumber}';

    const CONFIRM_AN_ORDER_END_POINT = 'order/confirm';

    const ADD_AN_SHIPMENT_TO_ORDER_ITEMS_END_POINT = 'order/shipped';

    const CANCEL_ORDER_END_POINT = 'order/cancel-order';

    /* Orders End Points */

    /* Returns End Points */

    const GET_RETURN_BY_REQUEST_NUMBER_END_POINT = 'order/returns/return-number/{returnNumber}';

    const GET_RETURN_BY_ORDER_NUMBER_END_POINT = 'order/returns/order-number/{orderNumber}';

    const GET_QUERY_RETURN_END_POINT = 'order/returns/list';

    const PROCESS_REFUND_END_POINT = 'order/returns/process-refund';

    const DELETE_LISTING_BY_SKU_ENDPOINT = 'listing/delete';

    /* Returns End Points */

    /**
     * End Point's Suffix end
     */

    /**
     * Constructor.
     *
     * @param bool $private If this is a private or public app
     *
     * @return self
     */
    public function _construct()
    {
        parent::_construct();
    }

    /**
     * Runs a request to the Shopify API.
     *
     * @param string     $type   The type of request... GET, POST, PUT, DELETE
     * @param string     $path   The Shopify API path... /admin/xxxx/xxxx.json
     * @param array|null $params Optional parameters to send with the request
     *
     * @return array An array of the Guzzle response, and JSON-decoded body
     */
    public function rest(string $type, string $path, array $params = [], $headers = [])
    {
        try {
            if (is_array($headers)) {
                if (empty($headers) || !isset($headers['Api-Key'])) {
                    $headers['Api-Key'] = $this->getApiKey($params);
                }
            }
            $params['mode'] = "production";
            $endPoint = $this->getApiUrlPrefix($params) . $path;
            unset($params['mode']);
            $result = $this->call($endPoint, $headers, $params, $type);

            return $result;
        } catch (Exception $e) {
            if ($e instanceof ClientException || $e instanceof ServerException) {
                // 400 or 500 level error, set the response
                $response = $e->getResponse();
                $body = $response->getBody();

                // Build the error object
                $errors = (object) [
                    'success' => false,
                    'code' => $response->getStatusCode(),
                    'body' => $body->getContents(),
                    'exception' => $e,
                ];
            } else {
                // Else, rethrow
                throw $e;
            }
        }
    }

    /**
     * @param $url
     * @param array $headers
     * @param array $data
     * @param string $type
     * @return array
     */
    public function call($url, $headers = [], $data = [], $type = 'GET')
    {
        /* unset remote info before calling API start */
        if (isset($data['_url'])) {
            unset($data['_url']);
        }

        if (isset($data['shop_id'])) {
            unset($data['shop_id']);
        }

        if (isset($data['sAppId'])) {
            unset($data['sAppId']);
        }


        /* unset remote info before calling API end */
        $client = new Client(["verify" => false]);
        switch ($type) {
            case 'DELETE':
                $response = $client->delete(
                    $url,
                    [
                        'headers' => $headers,
                        'query' => $data,
                        'http_errors' => false,
                    ]
                );
                $data = json_decode($response->getBody()->getContents(), true);
                break;
            case 'DELETE/FORM':
                $headers['Content-Type'] = 'application/json';
                $response = $client->delete(
                    $url,
                    [
                        'headers' => $headers,
                        'body' => json_encode($data),
                        'http_errors' => false,
                    ]
                );
                $data = json_decode($response->getBody()->getContents(), true);
                break;

            case 'POST':
                $headers['Content-Type'] = 'application/json';
                $response = $client->post(
                    $url,
                    [
                        'headers' => $headers,
                        'body' => json_encode($data, JSON_UNESCAPED_SLASHES),
                        'http_errors' => false
                    ]
                );
                $data = json_decode($response->getBody()->getContents(), true);
                break;
            case 'EXPORT_EXCEL':
                $headers['Content-Type'] = 'application/json';
                $allowedParams = [
                    'pageNumber',
                    'pageSize',
                    'status',
                    'primarySkuNumbers',
                    'sortBy',
                    'ascending',
                ];
                $params = [];
                foreach ($allowedParams as $param) {
                    if (isset($data[$param])) {
                        $params[] = $param . '=' . $data[$param];
                    }
                }
                if (count($params)) {
                    $url .= '?' . implode('&', $params);
                }
                $response = $client->post(
                    $url,
                    [
                        'headers' => $headers,
                        'form_params' => $data,
                        'http_errors' => false,
                    ]
                );
                return $response;
                break;

            case 'MEDIA':
                $response = $client->request(
                    'POST',
                    $url,
                    [
                        'multipart' => $data,
                        'headers' => $headers,
                        'http_errors' => false,
                    ]
                );
                $data = json_decode($response->getBody()->getContents(), true);
                break;

            case 'PUT':
                $headers['Content-Type'] = 'application/json';
                $response = $client->put(
                    $url,
                    [
                        'headers' => $headers,
                        'body' => json_encode($data, JSON_UNESCAPED_SLASHES),
                        'http_errors' => false
                    ]
                );
                $data = json_decode($response->getBody()->getContents(), true);
                break;

            default:
                $headers['Content-Type'] = 'application/json';
                $response = $client->get(
                    $url,
                    [
                        'headers' => $headers,
                        'query' => $data,
                        'http_errors' => false,
                    ]
                );

                $data = json_decode($response->getBody()->getContents(), true);
                break;
        }
        $responseData = [
            'code' => $data['code'],
            'message' => isset($data['message']) ? $data['message'] : '',
            'success' => false,
        ];
        if ($data['code'] == 200) {
            $responseData['message'] = 'Succeeded';
            $responseData['success'] = true;
        }
        $responseData['data'] = isset($data['data']) ? $data['data'] : [];
        return $responseData;
    }

    /**
     * @return string
     */
    public function getApiKey($param = [])
    {
        if (count($param) > 0 && isset($param['mode'])) {
            $shop = $this->di->getRegistry()->getCurrentShop();
            if (isset($shop['apps'][0][self::MICHAELS_API_KEY_FIELD . '_' . $param['mode']])) {
                return $shop['apps'][0][self::MICHAELS_API_KEY_FIELD . '_' . $param['mode']];
            }
            return '';
        }
        $shop = $this->di->getRegistry()->getCurrentShop();
        if (isset($shop['apps'][0][self::MICHAELS_API_KEY_FIELD])) {
            return $shop['apps'][0][self::MICHAELS_API_KEY_FIELD];
        }
        return '';
    }

    /**
     * @return mixed
     */
    public function getCurrentShop()
    {
        return $this->di->getRegistry()->getCurrentShop();
    }

    /**
     * @return mixed
     */
    public function getApiUrlPrefix($params)
    {
        $config = $this->di->getConfig()->get('app-config')->get('michael');
        if (isset($params['mode']) && $params['mode'] == 'production') {
            return $config->get(self::PRODUCTION_API_URL_PREFIX_CONFIG_INDEX);
        }
        if (isset($params['mode']) && $params['mode'] == 'order_sandbox') {
            return $config->get(self::SANDBOX_ORDER_API);
        }

        return $config->get(self::SANDBOX_API_URL_PREFIX_CONFIG_INDEX);
    }

    /**
     * @param $emailAddress
     * @return bool
     */
    public function checkEmail($emailAddress)
    {
        if (filter_var($emailAddress, FILTER_VALIDATE_EMAIL) !== false) {
            return true;
        }

        return false;
    }
}
