<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Components\Authenticate;

use App\Michaelswebapi\Components\Core\Common As CoreCommon;

/**
 * Class Authenticate
 * @package App\Michaelswebapi\Components\Authenticate
 */
class Authenticate extends CoreCommon
{
    /**
     * @param string $apiKey
     * @return mixed
     */
    public function testApiKey($apiKey = '',$params=[]) {
        $headers = [
            'Api-Key' => $apiKey
        ];
        return $this->rest('GET', self::AUTHENTICATION_TEST_AUTH_END_POINT, $params, $headers);
    }
}