<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Components;

use App\Michaelswebapi\Components\Core\Common As CoreCommon;

/**
 * Class Authenticate
 * @package App\Michaelswebapi\Components
 */
class Authenticate extends CoreCommon
{
    /**
     * @param array $data
     * @return array
     */
    public function addMichaelsInformation($data = []) {
        $email = trim(strtolower($data[self::MICHAELS_EMAIL_FIELD]));
        $apikey = trim($data[self::MICHAELS_API_KEY_FIELD]);
        $domain = trim($data[self::MICHAELS_DOMAIN_FIELD]);
        if ($email && $apikey && $domain) {
            $authenticateClass = $this->di->getObjectManager()->get(Authenticate\Authenticate::class);
            if (!$authenticateClass->checkEmail($email)) {
                return [
                    "success" => false,
                    "message" => "Please Enter Valid Email." ,
                ];
            }
            $response = $authenticateClass->testApiKey($apikey);
            if (isset($response['code'])) {
                if ($response['code'] == 200) {
                    $response = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                        false,
                        false,
                        [
                            self::MICHAELS_EMAIL_FIELD => $email,
                            self::MICHAELS_API_KEY_FIELD => $apikey,
                            self::MICHAELS_DOMAIN_FIELD => $domain
                        ],
                        [self::MICHAELS_DOMAIN_FIELD]
                    );
                    return $response;
                }
                return [
                    "success" => false,
                    "message" => $response['message'],
                ];
            }
        }
        return [
          'success' => false,
          'message' => 'Unable to Authenticate.'
        ];
    }
}