<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Components\Taxonomy As ComponentTaxonomy;
use App\Michaelswebapi\Api\Base;

/**
 * Class Taxonomy
 * @package App\Michaelswebapi\Api
 */
class Taxonomy extends Base
{
    protected $_component = 'Taxonomy';

    /**
     * @param array $data
     * @return array
     */
    public function getTaxonomyAttributes($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentTaxonomy::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentTaxonomy::class)->getTaxonomyAttributes($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentTaxonomy::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getTaxonomy($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentTaxonomy::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentTaxonomy::class)->getTaxonomy($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentTaxonomy::SHOP_NOT_FOUND_ERROR_MESSAGE,
                    'key'=>$this->di->getRegistry()->getCurrentShop(),
                    'data'=>$data
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}