<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Components\Returns As ComponentReturns;
use App\Michaelswebapi\Api\Base;

/**
 * Class Returns
 * @package App\Michaelswebapi\Api
 */
class Shop extends Base
{
    public function get($data) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                $shop['email'] = $shop['apps'][0]['email'];
                return ['success' => true, 'data' => $shop];
            }
            else {
                return ['success'=>false,'message' => 'Shop Not Found.'];
            }
        }
        catch(\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }
    }
}