<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Components\Returns As ComponentReturns;
use App\Michaelswebapi\Api\Base;

/**
 * Class Returns
 * @package App\Michaelswebapi\Api
 */
class Returns extends Base
{
    protected $_component = 'Returns';

    /**
     * @param array $data
     * @return array
     */
    public function getReturnByReturnNumber($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentReturns::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                if (!isset($data['returnNumber'])) {
                    return [
                        'success' => false,
                        'message' => "Required String parameter 'returnNumber' is not present."
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentReturns::class)->getReturnByReturnNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentReturns::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getReturnByOrderNumber($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentReturns::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                if (!isset($data['orderNumber'])) {
                    return [
                        'success' => false,
                        'message' => "Required String parameter 'orderNumber' is not present."
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentReturns::class)->getReturnByOrderNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentReturns::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getQueryReturns($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentReturns::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentReturns::class)->getQueryReturns($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentReturns::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function processRefund($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentReturns::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentReturns::class)->processRefund($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentReturns::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

}