<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Components\Order As ComponentOrder;
use App\Michaelswebapi\Api\Base;

/**
 * Class Order
 * @package App\Michaelswebapi\Api
 */
class Order extends Base
{
    protected $_component = 'Order';

    /**
     * @param array $data
     * @return array
     */
    public function getQueryOrder($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                $res= $this->di->getObjectManager()->get(ComponentOrder::class)->getQueryOrder($data);
                // $res['chek'] = true;
                return $res;
            } else {
                return [
                    'success' => false,
                    'data' => $data,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getOrderByOrderNumber($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                if (!isset($data['orderNumber'])) {
                    return [
                        'success' => false,
                        'message' => "Required String parameter 'orderNumber' is not present."
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->getOrderByOrderNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function confirmAnOrder($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->confirmAnOrder($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function addAnShipmentToOrderItems($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->addAnShipmentToOrderItems($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function cancelOrder($data = []) {
        try{
            if($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentOrder::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentOrder::class)->cancelOrder($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentOrder::SHOP_NOT_FOUND_ERROR_MESSAGE
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}