<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Api\Base;

/**
 * Class Taxonomy
 * @package App\Michaelswebapi\Api
 */
class Migration extends Base
{
    protected $_component = 'Migration';
    public $michael_remote;
    public $Dbconfig;
    public $old_michael;

    public function init()
    {
        $this->Dbconfig = $this->di->getConfig()->get('databases')->toArray();
        $this->old_michael = $this->Dbconfig['old_michael'];
        $this->michael_remote = $this->setDbSource($this->old_michael);
    }


    public function setDbSource($database, $dbName = false)
    {
        $dsn =  $database['host'];
        $mongo = new \MongoDB\Client($dsn, array("username" => $database['username'], "password" => $database['password']));
        $mongo =  $mongo->selectDatabase($database['dbname']);

        return $mongo;
    }
    /**
     * @param array $data
     * @return array
     */
    public function get($data)
    {
        $this->init();
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $appsShop = [];
        
        foreach ($data['shop'] as $shopData) {
            $shop = $this->michael_remote->selectCollection("apps_shop")->findOne(['_id' => (int)$shopData['remote_shop_id']]);
            $shop = json_decode(json_encode($shop), true);
            $cif_app_id = (string)$mongo->getCounter('apps_id');
            if ($shopData['marketplace'] == 'shopify') {
                $query = '{
                    app {
                        id
                        }
                    }
                    ';

                $url = 'https://' . $shop['shop_url'] . '/admin/api/2021-07/graphql.json';

                $headers = [
                    'Content-Type' => 'application/graphql',
                    'X-Shopify-Access-Token' => $shop['token']
                ];
                $response = $this->di->getObjectManager()->get('App\Core\Components\Guzzle')
                    ->call($url, $headers, $query, 'POST', 'body');
                if (isset($response['errors'])) {
                    $this->di->getLog()->logContent('failed -> ' . json_encode($shop, 128), 'info', 'failed_app_shop.log');
                    return $this->prepareResponse(['success' => false, 'data' => $shop['errors']]);
                }
                $id = explode('App/', $response['data']['app']['id'])[1];

                // $cif_app_id = "4";
                $format_shop[] = [
                    "_id" => (string)$shop['_id'],
                    "apps" => [
                        [
                            "shop_url" => $shop['shop_url'],
                            "client_id" => $shop['app_key'],
                            "client_secret" => $shop['app_secret'],
                            "shopify_app_id" => $id,
                            "is_private" => true,
                            "token" => $shop['token'],
                            "cif_app_id" => $cif_app_id,
                            "app_code" => "shopify_michael",
                            "app_id" => "1",
                            "sub_app_id" => "1",
                            "active" => true
                        ]
                    ],
                    "group_code" => "shopify_michael",
                    "id" => (string)$shop['_id'],
                    "shop_url" => $shop['shop_url'],
                    "sub_apps" => [
                        "1"
                    ]
                ];
                $format_cedcommerce_app_shops[] = ["remote_shop_id" => (string)$shop['_id'],  "sAppId" => "1",  "ced_subuser_id" => "1",  "ced_sAppId" => "3"];
            } elseif ($shopData['marketplace'] == 'michaels') {
                $format_shop[] = [
                    "_id" => (string)$shop['_id'],
                    "apps" => [
                        [
                            "michaels_api_key" => $shop['michaels_api_key'],
                            "email" => $shop['email'],
                            "domain" => $shop['domain'],
                            "is_private" => true,
                            "cif_app_id" => $cif_app_id,
                            "app_code" => "michael_woo_shopify",
                            "app_id" => "2",
                            "sub_app_id" => "2",
                            "active" => true
                        ]
                    ],
                    "domain" => $shop['domain'],
                    "id" => (string)$shop['_id'],
                    "group_code" => $shop['shop_url'],
                    "sub_apps" => [
                        "2"
                    ]
                ];
                $format_cedcommerce_app_shops[] = ["remote_shop_id" => (string)$shop['_id'],  "sAppId" => "2",  "ced_subuser_id" => "1",  "ced_sAppId" => "3"];
            }
            elseif ($shopData['marketplace'] == 'woocommerce') {
                $format_shop[] = [
                    "_id" => (string)$shop['_id'],
                    "apps" => [
                        [
                            "michaels_api_key" => $shop['michaels_api_key'],
                            "email" => $shop['email'],
                            "domain" => $shop['domain'],
                            "is_private" => true,
                            "cif_app_id" => $cif_app_id,
                            "app_code" => "michael_woo_shopify",
                            "app_id" => "2",
                            "sub_app_id" => "2",
                            "active" => true
                        ]
                    ],
                    "domain" => $shop['domain'],
                    "id" => (string)$shop['_id'],
                    "group_code" => $shop['shop_url'],
                    "sub_apps" => [
                        "2"
                    ]
                ];
                $format_cedcommerce_app_shops[] = ["remote_shop_id" => (string)$shop['_id'],  "sAppId" => "2",  "ced_subuser_id" => "1",  "ced_sAppId" => "3"];
            }
            $format_app[] = ["_id" => $cif_app_id,  "id" => $cif_app_id,  "is_visible" => false,  "shop_id" => (string)$shop['_id']];
        }
        // return ['success' => true,'format_shop' => $format_shop,'format_cedcommerce_app_shops' => $format_cedcommerce_app_shops,'format_app' => $format_app];
        $appsShopCollection = $mongo->getCollectionForTable("apps_shop");
        $insert = $appsShopCollection->insertMany($format_shop);

        $appsCollection = $mongo->getCollectionForTable("apps");
        $insert1 = $appsCollection->insertMany($format_app);

        $cedcommerceAppsShopCollection = $mongo->getCollectionForTable("cedcommerce_app_shops");
        $insert2 = $cedcommerceAppsShopCollection->insertMany($format_cedcommerce_app_shops);
        return ['success' => true];
    }
}
